<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Check if current install is WMVP PRO
 *
 */
function wmvp_is_pro() {
	return defined( 'WMVP_PRO' ) && WMVP_PRO;
}


/**
 * Get plugin's Settings
 */
function wmvp_get_option( $name, $default = false ) {

	$options = get_option( 'wmvp_options' );

	if( ! empty( $options[ $name ] ) ){
		return $options[ $name ];
	}

	return $default;
}


/**
 * Get Playlist custom option
 */
 function wmvp_get_playlist_meta( $key, $default = false, $entry_id = null ){

	if( ! $entry_id ){
		$entry_id = isset( $GLOBALS['WMVP_current_id'] ) ? $GLOBALS['WMVP_current_id'] : get_the_ID();
	}

	if( $value = get_post_meta( $entry_id, $key, $single = true ) ){
		return $value;
	}
	
	return $default;
}


/**
 * Get option > post > plugin options
 */

function wmvp_get_object_option( $key = false, $default = false ){

	if( empty( $key ) ){
		return false;
	}

	// Prefix the settings
	$post_key = 'wmvp-'. $key;

	// Get the post option if exists
	$option = wmvp_get_playlist_meta( $post_key );

	// In the single playlist settings we use the empty value for default and no for disable
	if( ! empty( $option ) && $option == 'no' ){
		return false;
	}
	
	if( empty( $option ) ){ 
		$option = wmvp_get_option( $key, $default ); 	// Get the global value
	}

	return apply_filters( 'WMVP/object_option', $option, $key, $post_key );
}


/**
 * Trim Words
 */
function wmvp_trim_words( $text = '', $limit = false ){
	
	$limit = ! empty( $limit ) ? $limit : wmvp_get_object_option( 'trim_limit' );

	if( empty( $limit ) ){
		return $text;
	}

	// For Chinese Language
	if( wmvp_get_object_option( 'trim_type' ) == 'chars' ){
		if ( function_exists( 'mb_substr' ) ) {
			return mb_substr( $text, 0, $limit );
		}
		return substr( $text, 0, $limit );
	}

	return wp_trim_words( $text, $limit, '&hellip;' );
}


/**
 * Upgrade to PRO link
 */
function wmvp_go_pro( $utm_data = array() ){

	return add_query_arg(
		wp_parse_args( $utm_data, array(
			'utm_source'   => 'free-version',
			'utm_campaign' => 'wmvp-upgrade',
			'utm_medium'   => 'link',
			'utm_content'  => false
		)),
		'https://watermelonwp.com/wm-video-playlists-pro-plugin-for-wordpress/'
	);
}


/**
 * Return the base admin-area URL.
 *
 * Use this to avoid typing all of it out a million times.
 */
function wpvp_get_admin_url( $args = array()) {

	// Default args
	$args = wp_parse_args( $args, array(
		'post_type' => WMVP_POST_SLUG,
		'page'      => WMVP_POST_SLUG .'-settings',
	));

	// Default URL
	$admin_url = admin_url( 'edit.php' );

	// Get the base admin URL
	return add_query_arg( $args, $admin_url );
}


/**
 * Pro Label
 */
function wmvp_pro_label( $return = false ){

	$url = wmvp_go_pro(
		array(
			'utm_medium'  => 'disabled-features',
			'utm_content' => 'upgrade-to-pro',
		)
	);

	$label = '<a href="'. esc_url( $url ) .'" target="_blank" class="wmvp-pro-label">Pro</a>';

	if( $return ){
		return $label;
	}
	
	echo $label;
}


/**
 * Get List of Playlists
 */
function wmvp_get_playlists_list( $label = false, $empty_msg = false ){

	$playlists = array();

	// Default Label
	if( ! empty( $label ) ){
		$playlists[] = esc_html__( '- Select a Playlist -', 'wm-video-playlists' );
	}

	// Query the Video Playlist
	$args = array(
		'post_type'      => WMVP_POST_SLUG,
		'post_status'    => 'publish',
		'posts_per_page' => -1,
		'no_found_rows'  => true,
	);

	$get_playlists = get_posts( $args );

	// Add the Video Playlists to the array
	if( ! empty( $get_playlists ) && is_array( $get_playlists ) ){
		foreach ( $get_playlists as $list ){
			$playlists[ $list->ID ] = ! empty( $list->post_title ) ? $list->post_title : esc_html__( '(no title)', 'wm-video-playlists' ) . " - #$list->ID" ;
		}
	}
	elseif( $empty_msg ){
		return wmvp_notice_inline( esc_html__( 'No Playlists found.', 'wm-video-playlists' ) .' - '. '<a href="'. wpvp_get_admin_url( array( 'page'=> false ) ) .'">'. esc_html__( 'Add a video playlist', 'wm-video-playlists' ) .'</a>', 'info', false );
	}

	return $playlists;
}


/**
 * Admin Notices
 */
function wmvp_notice( $message ='', $type = false, $echo = true, $minimal = false ){

	if( empty( $message ) ){
		return;
	}

	// Class
	$class   = array( 'wmvp-notice' );
	$class[] = $type    ? "wmvp-notice-$type"   : '';
	$class[] = $minimal ? "wmvp-notice-minimal" : '';

	// Icon
	switch ( $type ) {

		case 'success':
			$icon = 'yes-alt';
			break;

		case 'error':
			$icon = 'dismiss';
			break;

		case 'info':
			$icon = 'info';
			break;
		
		default:
			$icon = 'warning';
			break;
	}

	$message = '<div class="'. join( ' ', $class ).'"><p><span class="dashicons dashicons-'. $icon .'"></span> '. $message .'</p></div>';

	if( $echo ){
		echo $message;
	}

	return $message;
}


/**
 * Minmal notice
 */
function wmvp_notice_inline( $message ='', $type = false, $echo = true ){
	return wmvp_notice( $message, $type, $echo, true );
}


/**
 * Build The Plugin options
 */
function wmvp_build_option( $option, $id, $value ){
	//echo "'$id',<br />";
	new WMVP_Settings( $option, $id, $value );
}
