<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Output date
 */
function wmvp_get_time( $date = false, $before = '<span class="wmvp-video-date">', $after = '</span>' ){

	if( empty( $date ) ){
		return;
	}

	// Human Readable Post Dates
	if( wmvp_get_object_option( 'time_format' ) == 'modern' ){

		$time_now  = current_time( 'timestamp' );

		if ( $date > ( $time_now - MONTH_IN_SECONDS ) ){
			/* translators: $s will be replaced by the date. */
			$since = sprintf( esc_html__( '%s ago', 'wm-video-playlists' ), human_time_diff( $date, $time_now ) );
		}
	}

	// Default date format
	if( empty( $since ) ){
		$since = date_i18n( get_option( 'date_format' ), $date );
	}

	// The date markup
	return $before . $since . $after;
}


/**
 * Video Description 
 */
function wmvp_get_description( $description = '' ){

	return; // Future Update

	if( empty( $description ) ){
		return false;
	}

	$description = preg_replace('/#(\p{L}\w*)|.*#(\p{N}\w*)/u', "<a href=\"https://www.youtube.com/hashtag/$1\" target=\"_blank\" rel=\"nofollow noopener\">#$1</a>", $description );
	//$description = apply_filters( 'the_content', make_clickable( $description ) );
	$description = make_clickable( wpautop( $description ) );
	$description = htmlspecialchars( $description );
	$description = str_replace( '&amp;#', '&#', $description );

	return $description;
}


/**
 * Get Video thumbnail
 */
function wmvp_get_video_thumbnail( $video ){
	
	if ( ! empty( $video['thumbnails']['medium'] ) ){
		return $video['thumbnails']['medium'];
	}
	
	if( ! empty( $video['thumbnails']['default'] ) ){
		return $video['thumbnails']['default'];
	}

	return WMVP_PLUGIN_URL .'/includes/admin/assets/images/blank.png';
}


/**
 * Retuen the videos array after removing the disabled videos
 */
function wmvp_get_active_videos( $videos = array(), $type = 'automatic' ){

	// Automatic - check for the disable
	if( ! empty( $videos ) && is_array( $videos ) && $type == 'automatic' ){

		foreach( $videos as $key => $video ){
			if( ! empty( $video['disable'] ) ){
				unset( $videos[ $key ] );
			}
		}
	}

	return $videos;
}


/**
 * wmvp_playlist Shortcode
 */
add_shortcode( 'wmvp_playlist', 'wmvp_video_playlist_shortcode' );
function wmvp_video_playlist_shortcode( $atts = array() ) {

	if( empty( $atts['id'] ) ){
		return;
	}

	ob_start();

	$args = apply_filters( 'WMVP/Shortcode/args', false, $atts );

	wmvp_videos_list( $atts['id'], $args );

	return '
		<div class="wmvp-video-playlist-shortcode">'.
			ob_get_clean() .'
		</div>
	';
}



/**
 * Videos List Template
 */
function wmvp_videos_list( $entry_id = false, $args = array() ){

	if( empty( $entry_id ) ){
		return;
	}

	$GLOBALS['WMVP_current_id'] = $entry_id;
	
	// Get the List Type Manual ? Automatic
	$type = get_post_meta( $entry_id, 'wmvp-list-type', true );

	// Get the Saved Videos
	$saved_videos = get_post_meta( $entry_id, 'wmvp_videos_'.$type, true );
	
	$saved_videos = apply_filters( 'WMVP/Videos', $saved_videos, $type, $entry_id );

	// Remove Disabled Videos from the list
	$saved_videos = wmvp_get_active_videos( $saved_videos, $type );

	// --
	if( empty( $saved_videos ) || ! is_array( $saved_videos ) ){
		echo '<div style="background-color: #FFF8DC;padding:20px;border: 0 solid #ffeb8e;">'. esc_html__( 'No Videos Found', 'wm-video-playlists' ) .'</div>';
		return;
	}

  $args = wp_parse_args( $args, array(
		'has_title'    => wmvp_get_object_option( 'player_title' ),
		'custom_title' => false,
		'style'        => false,
		'title_limit'  => wmvp_get_object_option( 'trim_limit' ),
		'has_date'     => wmvp_get_object_option( 'date' ),
		'has_duration' => wmvp_get_object_option( 'duration' ),
		'has_numbers'  => wmvp_get_object_option( 'numbers' ),
		'has_thumb'    => true,
		'layout'       => 'vertical',
	) );
	
	$args = apply_filters( 'WMVP/Videos/args', $args, $entry_id );

	// Classes
	$block_class = array( 'wmvp-videos-block' );
	$block_class['style']  = wmvp_get_object_option( 'style', 'dark' ) . '-skin';
	$block_class['layout'] = 'wmvp-layout-vertical';

	// Numbers
	if( $args['has_numbers'] ){
		$block_class['numbers'] = 'wmvp-has-numbers';
	}
	
	// Title
	if( $args['has_title'] ){
		$title = ! empty( $args['custom_title'] ) ? $args['custom_title'] : get_the_title( $entry_id );
		$block_class['title'] = 'wmvp-playlist-has-title';
	}

	$block_class = apply_filters( 'WMVP/Videos/classes', $block_class, $args, $entry_id );

	// Variables
	$id = 'wmvp-' . $entry_id . time();
	$videos_count = count( $saved_videos );
	$videos_list  = array();

	if( ! get_option( 'wmvp_youtube_key' ) ){
		echo '<div style="background-color: #FFF8DC;padding:20px;border: 0 solid #ffeb8e;">'. esc_html__( 'You need to set the YouTube API Key in the plugin settings page to be able to add videos.', 'wm-video-playlists' ) .'</div>';
	}
	

	// Avoid ID duplication if the user added the same playlist multiple times
	$block_id = "wmvp-playlist-$entry_id";

	if( isset( $GLOBALS[ $block_id ] ) ){
		$number   = (int)$GLOBALS[ $block_id ] + 1;
		$block_id = "wmvp-playlist-$entry_id-$number";
	}
	else{
		$GLOBALS[ $block_id ] = 0;
	}

	// Custom Styles
	wmvp()->inline_styles( '#'.$block_id, $args['style'] );
	?>

	<div id="<?php echo esc_attr( $block_id ) ?>" class="<?php echo esc_attr( join( ' ', $block_class ) ) ?>">
		
		<?php do_action( 'WMVP/before_playlist_inner', $args, $saved_videos, $entry_id ) ?>
		
		<div class="wmvp-videos-block-inner">
			<div class="wmvp-video-player-wrapper">
				<div class="wmvp-loader-overlay"><div class="wmvp-spinner-circle"></div></div>
				<div class="wmvp-video-player">
					<iframe loading="lazy" class="wmvp-the-video" id="video-<?php echo esc_attr( $id ) ?>-1" src="<?php echo esc_attr( $saved_videos[ array_key_first( $saved_videos ) ]['embed_path'] ) ?>" title="Videos List" width="771" height="434" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen async></iframe>
				</div><!-- .wmvp-video-player -->
			</div><!-- .wmvp-video-player-wrapper /-->

			<div class="wmvp-playlist-nav-wrapper">
				<?php if( ! empty( $title ) ): ?>
					<div class="wmvp-playlist-head-section">
						
						<?php do_action( 'WMVP/before_head_section', $args, $saved_videos, $entry_id ) ?>

						<div class="wmvp-playlist-head-section-inner">
							<div class="wmvp-playlist-head-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M73 39c-14.8-9.1-33.4-9.4-48.5-.9S0 62.6 0 80L0 432c0 17.4 9.4 33.4 24.5 41.9s33.7 8.1 48.5-.9L361 297c14.3-8.7 23-24.2 23-41s-8.7-32.2-23-41L73 39z"/></svg></div>
							<div class="wmvp-playlist-title-section">
								<div class="wmvp-playlist-title"><?php echo esc_html( $title ) ?></div>
								<div class="wmvp-head-videos-number">
									<span class="wmvp-video-playing-number">1</span> / <span class="wmvp-video-totlal-number"><?php echo esc_attr( $videos_count ) ?></span> <?php esc_html_e( 'Videos', 'wm-video-playlists' ); ?>
								</div><!-- .wmvp-head-videos-number -->
							</div><!-- .wmvp-playlist-title-section -->
						</div> <!-- .wmvp-playlist-head-section-inner /-->

						<?php do_action( 'WMVP/after_head_section', $args, $saved_videos, $entry_id ) ?>

					</div> <!-- .wmvp-playlist-head-section /-->
				<?php endif; ?>

				<div class="wmvp-video-playlist-nav">
					<?php
					$video_number = 0;
					foreach( $saved_videos as $video ):
						$video_number++;
						$video_title = ! empty( $video['custom_title'] ) ? $video['custom_title'] : $video['title'];
						$video_title = wmvp_trim_words( $video_title, $args['title_limit'] );
						?>
						<div class="wmvp-video-playlist-item" data-name="video-<?php echo esc_attr( $id. '-' .$video_number ) ?>" data-video-src="<?php echo esc_attr( $video['embed_path'] ) ?>" data-video-bg="<?php echo esc_attr( wmvp_get_video_thumbnail( $video ) ) ?>" data-description="<?php echo esc_attr( wmvp_get_description( $video['description'] ) ) ?>">
							<div class="wmvp-video-status">
								<div class="wmvp-video-number"><?php echo esc_attr( $video_number ) ?></div>
								<div class="wmvp-video-play-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M73 39c-14.8-9.1-33.4-9.4-48.5-.9S0 62.6 0 80L0 432c0 17.4 9.4 33.4 24.5 41.9s33.7 8.1 48.5-.9L361 297c14.3-8.7 23-24.2 23-41s-8.7-32.2-23-41L73 39z"/></svg></div>
								<div class="wmvp-video-paused-icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M48 64C21.5 64 0 85.5 0 112L0 400c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48L48 64zm192 0c-26.5 0-48 21.5-48 48l0 288c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48l-32 0z"/></svg></div>
							</div><!-- .wmvp-video-status -->
							<?php if( $args['has_thumb'] ){ ?>
								<div class="wmvp-video-thumbnail">
									<img src="<?php echo esc_attr( wmvp_get_video_thumbnail( $video ) ); ?>" loading="lazy" alt="" width="120" height="90" />
							</div>
							<?php } ?>
							<div class="wmvp-video-info">
								<div class="wmvp-video-title"><?php echo esc_html( $video_title ) ?></div>
								<div class="wmvp-video-meta">
									<?php
										if( $args['has_duration'] ){ ?>
											<span class="wmvp-video-duration"><?php echo esc_html( $video['duration'] ); ?></span>
										<?php
										} 
									
										if( $args['has_date'] ){
											echo wmvp_get_time( $video['published'] );
										}
									?>
								</div>
							</div><!-- .wmvp-video-info -->
						</div><!-- .wmvp-video-playlist-item -->
						<?php
					endforeach;
					?>
				</div><!-- .wmvp-video-playlist-nav /-->
			</div><!-- .wmvp-playlist-nav-wrapper /-->
		</div><!-- .wmvp-videos-block-inner /-->

		<?php do_action( 'WMVP/after_playlist_inner', $args, $saved_videos, $entry_id ) ?>

	</div><!-- .videos-block /-->
	<?php

	// Enqueue the Video Playlist Js file
	wp_enqueue_script( 'wmvp-js-videos-list' );

	// Reset
	wp_reset_postdata();
	$GLOBALS['WMVP_current_id'] = false;
}