  const countdownOverlay = document.getElementById('countdownOverlay');
  const countdownTimer = document.getElementById('countdownTimer');
  // use existing videoFrame and loadingIndicator declared earlier

  let countdown = 3 // seconds before iframe appears

  const timer = setInterval(() => {
    countdown--;
    countdownTimer.textContent = countdown;

    if (countdown <= 0) {
      clearInterval(timer);

      // Hide countdown overlay smoothly
      countdownOverlay.style.opacity = '0';
      setTimeout(() => {
        countdownOverlay.style.display = 'none';
        // Once countdown ends, show and activate the iframe
        videoFrame.style.opacity = '1';
        videoFrame.style.pointerEvents = 'auto';
      }, 500);
    }
  }, 1000);

  // ✅ Optional safety: if iframe loads before countdown ends, keep it hidden until timer finishes
  videoFrame.addEventListener('load', () => {
    if (countdown <= 0) {
      videoFrame.classList.add('loaded');
      loadingIndicator.style.opacity = '0';
      setTimeout(() => loadingIndicator.style.display = 'none', 300);
    }
  });