<?php
$url = isset($_GET['url']) ? trim($_GET['url']) : null;
if (!$url) {
    die("<h2 style='color:red;text-align:center;margin-top:40vh;'>Error: Missing ?url= parameter</h2>");
}

if (!preg_match('/^https:\/\/play\.zephyrflick\.top/i', $url)) {
    die("<h2 style='color:red;text-align:center;margin-top:40vh;'>Invalid URL</h2>");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Player Proxy</title>
<style>
  html, body {
    margin: 0;
    padding: 0;
    height: 100%;
    background: #000;
  }
  iframe {
    width: 100%;
    height: 100%;
    border: none;
  }
</style>
</head>
<body>
  <iframe
    src="<?= htmlspecialchars($url, ENT_QUOTES) ?>"
    allowfullscreen
    frameborder="0"
    id="pixfusionPlayer">
  </iframe>

<script>
const iframe = document.getElementById('proxyFrame');

// Listen for load to ensure frame exists
iframe.addEventListener('load', () => {
  console.log('🎬 JW iframe loaded');

  try {
    // Capture errors/warnings logged inside iframe
    const iframeWin = iframe.contentWindow;

    // Proxy console messages (if same-origin or CORS allowed)
    if (iframeWin && iframeWin.console) {
      const originalWarn = iframeWin.console.warn;
      iframeWin.console.warn = function (...args) {
        if (args[0]?.includes?.('334001')) {
          console.log('✅ JWPlayer 334001 detected — playback complete');
          notifyParent();
        }
        return originalWarn.apply(this, args);
      };
    }
  } catch (err) {
    console.warn('⚠️ Unable to hook JW console (cross-origin)', err);
  }
});

// Send event upward to parent
function notifyParent() {
  if (window.parent && window.parent !== window) {
    window.parent.postMessage(
      { type: 'ended', status: 'completed', source: 'proxy' },
      '*'
    );
    window.parent.postMessage('video_playback_completed', '*');
  }
}
</script>

</body>
</html>
