<?php
// Get the base64 data from URL param
$dataParam = $_GET['data'] ?? '';

if (empty($dataParam)) {
    die("Missing 'data' parameter in URL.");
}

// Decode base64 safely
$decoded = base64_decode($dataParam, true);
if ($decoded === false) {
    die("Invalid data.");
}

// Decode JSON
$languages = json_decode($decoded, true);
if (!is_array($languages)) {
    die("Invalid JSON structure.");
}

// Get first language as default
$default = $languages[0];
$defaultLink = htmlspecialchars($default['link']);
$defaultLang = htmlspecialchars($default['language']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Multi Player</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
  <link href="/public/css/multi-css.css" rel="stylesheet">
</head>
<body>
  <div class="header">
    <button class="audio-btn" id="audioBtn">
      <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
        <path d="M3 9v6h4l5 5V4L7 9H3zm13.5 3c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02z"/>
      </svg>
      <?= $defaultLang ?>
    </button>
  </div>

<div class="video-container">
  <div class="countdown-overlay" id="countdownOverlay">
    <div class="countdown-circle">
      <span id="countdownTimer">3</span>
    </div>
    <div class="countdown-text">Please Wait...</div>
  </div>

  <iframe id="videoFrame" src="<?= $defaultLink ?>" allowfullscreen style="opacity:0;pointer-events:none;"></iframe>

  <div class="language-switch" id="loadingIndicator">
    <div class="loading-text">Loading video...</div>
    <div class="language-text">Audio: <span id="switchingLanguage"><?= $defaultLang ?></span></div>
  </div>
</div>

  <div id="audioModal" class="modal">
    <div class="modal-content">
      <h3>Select Audio</h3>
      <button class="close-btn" id="closeModal">&times;</button>
      <div class="audio-options">
        <?php foreach ($languages as $i => $lang): 
            $name = htmlspecialchars($lang['language']);
            $link = htmlspecialchars($lang['link']);
            $active = $i === 0 ? 'active' : '';
        ?>
          <div class="modal-option <?= $active ?>" data-link="<?= $link ?>" data-language="<?= $name ?>">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24">
              <path d="M3 9v6h4l5 5V4L7 9H3zm13.5 3c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02z"/>
            </svg>
            <?= $name ?>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>

<script>
  const videoFrame = document.getElementById('videoFrame');
  const loadingIndicator = document.getElementById('loadingIndicator');
  const audioModal = document.getElementById('audioModal');
  const audioBtn = document.getElementById('audioBtn');
  const switchingLanguage = document.getElementById('switchingLanguage');
  const options = document.querySelectorAll('.modal-option');

  // ✅ Load saved language label (not URL)
  const savedLang = localStorage.getItem('preferredLanguage');
  if (savedLang) {
    const match = Array.from(options).find(opt => opt.dataset.language === savedLang);
    if (match) {
      options.forEach(el => el.classList.remove('active'));
      match.classList.add('active');

      const selectedLang = match.dataset.language;
      const selectedLink = match.dataset.link;

      // Set correct iframe + UI
      videoFrame.src = selectedLink;
      switchingLanguage.textContent = selectedLang;
      audioBtn.innerHTML = `
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
          <path d="M3 9v6h4l5 5V4L7 9H3zm13.5 3c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02z"/>
        </svg>
        ${selectedLang}
      `;
    }
  }

  // ✅ Handle iframe loading
  videoFrame.addEventListener('load', function() {
    this.classList.add('loaded');
    this.classList.remove('switching');
    loadingIndicator.style.opacity = '0';
    setTimeout(() => { loadingIndicator.style.display = 'none'; }, 300);
  });

  // ✅ Open modal
  document.getElementById('audioBtn').addEventListener('click', function() {
    audioModal.style.display = 'block';
    document.body.style.overflow = 'hidden';
  });

  // ✅ Close modal buttons
  document.getElementById('closeModal').addEventListener('click', closeModal);
  window.addEventListener('click', function(event) {
    if (event.target === audioModal) closeModal();
  });
  document.addEventListener('keydown', function(event) {
    if (event.key === 'Escape') closeModal();
  });

  function closeModal() {
    audioModal.style.display = 'none';
    document.body.style.overflow = 'auto';
  }

  // ✅ Handle option click + save only label
  options.forEach(function(option) {
    option.addEventListener('click', function() {
      options.forEach(el => el.classList.remove('active'));
      this.classList.add('active');

      const newLink = this.getAttribute('data-link');
      const newLanguage = this.getAttribute('data-language');

      document.getElementById('switchingLanguage').textContent = newLanguage;
      loadingIndicator.style.display = 'block';
      setTimeout(() => { loadingIndicator.style.opacity = '1'; }, 10);

      videoFrame.classList.remove('loaded');
      videoFrame.classList.add('switching');
      videoFrame.src = newLink;

      document.getElementById('audioBtn').innerHTML = `
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
          <path d="M3 9v6h4l5 5V4L7 9H3zm13.5 3c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02z"/>
        </svg>
        ${newLanguage}
      `;

      // ✅ Save only label (language)
      localStorage.setItem('preferredLanguage', newLanguage);

      closeModal();
    });
  });
</script>
<script src="/public/js/count-js.js"></script>

</body>
</html>
