<?php
// Get ?url or ?Url parameter safely
$url = $_GET['url'] ?? $_GET['url'] ?? '';
$url = trim($url);

// Basic validation — allow only http/https
if (!preg_match('/^https?:\/\//i', $url)) {
    die('<h2 style="color:#fff;text-align:center;margin-top:20%;">⚠ Invalid or missing URL</h2>');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title>Proxy Player</title>
<style>
  html, body {
    margin: 0;
    padding: 0;
    height: 100%;
    background: #000;
    overflow: hidden;
  }
  iframe {
    border: none;
    width: 100%;
    height: 100%;
    display: block;
  }
  .loader {
    position: fixed;
    inset: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #000;
    color: #aaa;
    font-family: sans-serif;
  }
</style>
</head>
<body>
<div class="loader" id="loader">Loading player...</div>

<iframe
  id="proxyFrame"
  src="<?= htmlspecialchars($url, ENT_QUOTES, 'UTF-8') ?>"
  allowfullscreen
></iframe>

<script>
const frame = document.getElementById('proxyFrame');
const loader = document.getElementById('loader');

// When iframe finishes loading
frame.addEventListener('load', () => {
  console.log('🎬 Player iframe loaded.');
  loader.style.display = 'none'; // ✅ hide the loader
});

// Track playback / completion
let lastActivity = Date.now();
let completedNotified = false;

// 🕵️ Detect JWPlayer "complete" or "334001" warning even from console
const originalConsoleError = window.console.error;
window.console.error = function (...args) {
  try {
    const msg = args.join(' ');
    if (msg.includes('JW Player Warning 334001')) {
      if (!completedNotified) {
        completedNotified = true;
        console.log('%c✅ JWPlayer 334001 warning detected → playback completed', 'color:#0f0;font-weight:bold;');
        notifyParent('jwplayer_334001');
      }
    }
  } catch (e) {}
  if (originalConsoleError) originalConsoleError.apply(window.console, args);
};

// 🔄 Passive detection loop (UI-based / fallback)
setInterval(() => {
  try {
    const frameDoc = frame.contentDocument || frame.contentWindow.document;
    const text = frameDoc.body?.innerText?.toLowerCase() || "";

    // Detect JWPlayer replay UI or text states
    if (text.includes('replay') || text.includes('watch again')) {
      if (!completedNotified) {
        completedNotified = true;
        console.log('%c✅ JWPlayer likely completed (UI text detected)', 'color:#0f0;font-weight:bold;');
        notifyParent('ui_text_detected');
      }
    }
  } catch (e) {
    // CORS restriction (normal for external iframe)
  }

  // fallback inactivity timeout
  if (!completedNotified && Date.now() - lastActivity > 1000 * 60 * 30) {
    completedNotified = true;
    console.log('%c⏰ Timeout assumed video complete', 'color:#ffcc00;font-weight:bold;');
    notifyParent('timeout_fallback');
  }
}, 3000);

// 🔔 Relay message upward (Proxy → Parent)
function notifyParent(reason = 'unknown') {
  if (window.parent && window.parent !== window) {
    console.log('%c📩 Sending message to parent → video_playback_completed (' + reason + ')', 'color:#4af;font-weight:bold;');
    const payload = { type: 'ended', status: 'completed', source: 'proxy', reason };
    window.parent.postMessage(payload, '*');
    window.parent.postMessage('video_playback_completed', '*');
  } else {
    console.warn('⚠ No parent window detected — message not sent.');
  }
}
</script>


</body>
</html>
