<?php
require_once __DIR__ . '/../config.php';

// ✅ Check for ID parameter
if (empty($_GET['id'])) {
    die("Error: Missing ID parameter in URL.");
}

$id = trim($_GET['id']);

// ✅ Build API URL dynamically
define('BASE_API_URL', rtrim(API_URL, '/'));
$apiUrl = BASE_API_URL . '/details/?id=' . urlencode($id);

// ✅ Fetch data
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $apiUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 15,
    CURLOPT_FOLLOWLOCATION => true,
]);
$response = curl_exec($ch);

if (curl_errno($ch)) {
    die("cURL Error: " . curl_error($ch));
}

$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode !== 200) {
    die("API returned HTTP $httpCode");
}

// ✅ Decode JSON
$json = json_decode($response, true);
if (!is_array($json) || empty($json['data'])) {
    die("Invalid API response");
}

$data = $json['data'];

// Extract TMDB info
$tmdb = $data['tmdb'] ?? [];
$language = $data['languages'] ?? "N/A Language";
if (!empty($data['languages'])) {
    $languageLinks = [];

    // Break "Hindi-English-Japanese" into an array
    foreach (explode('-', $data['languages']) as $lang) {
        $lang = trim($lang);
        if ($lang === '') continue;

        // Build clean slug and link
        $slug = strtolower(preg_replace('/[^a-z0-9]+/i', '-', $lang));
        $url = "/language/{$slug}/";
        $languageLinks[] = '<a href="' . htmlspecialchars($url) . '">' . htmlspecialchars($lang) . '</a>';
    }

    $language_link = implode(', ', $languageLinks);
} else {
    $language_link = 'N/A Language';
}

$title = htmlspecialchars($tmdb['title'] ?? 'N/A Title');
$poster = !empty($tmdb['poster']) ? 'https://image.tmdb.org/t/p/w500' . $tmdb['poster'] : '/assets/no-image.jpg';
$backdrop = !empty($tmdb['backdrop']) ? 'https://image.tmdb.org/t/p/original' . $tmdb['backdrop'] : '';
$overview = htmlspecialchars($tmdb['overview'] ?? 'No description available.');
$rating = $tmdb['rating'] ?? 'N/A';
$releaseYear = $tmdb['release_year'] ?? 'N/A';
$season = $tmdb['season'] ?? 'N/A';
$runtime = $tmdb['episode_runtime'] ?? null;

// ensure runtime is numeric and valid
if (is_numeric($runtime) && $runtime > 0) {
    $hours = floor($runtime / 60);
    $minutes = $runtime % 60;

    if ($hours > 0 && $minutes > 0) {
        $runtime = "{$hours}h {$minutes}";
    } elseif ($hours > 0) {
        $runtime = "{$hours}h";
    } else {
        $runtime = "{$minutes}";
    }
} else {
    $runtime = ''; // empty if invalid
}


if (!empty($tmdb['genre'])) {
    $genreLinks = [];
    $genres = array_slice($tmdb['genre'], 0, 10); // limit to 10 items max

    foreach ($genres as $genre) {
        $slug = strtolower(trim(preg_replace('/[^a-z0-9]+/i', '-', $genre)));
        $url = SITE_URL . "/genre/" . $slug . "/";
        $genreLinks[] = '<a href="' . htmlspecialchars($url) . '">' . htmlspecialchars($genre) . '</a>';
    }

    $genreList = implode(', ', $genreLinks);
} else {
    $genreList = 'Unknown';
}

$trailers = $tmdb['trailers'] ?? [];

if (!empty($trailers)) {
    // Pick first trailer (or show multiple if you want)
    $firstTrailer = $trailers[0]['url'] ?? '';

    // Convert normal YouTube URL → embed format
    if (preg_match('/(?:v=|youtu\.be\/)([A-Za-z0-9_-]{11})/', $firstTrailer, $matches)) {
        $videoId = $matches[1];
        $embedUrl = "https://www.youtube.com/embed/" . $videoId;
    } else {
        $embedUrl = ''; // fallback
    }
}
if (!empty($tmdb['ott']) && is_array($tmdb['ott'])) {
    $ottLinks = [];

    // ✅ Only allow these platforms
    $allowed = ['netflix', 'crunchyroll', 'disney-plus', 'amazon-video'];

    foreach ($tmdb['ott'] as $name => $slug) {
        // Clean slug
        $slug = strtolower(trim(preg_replace('/[^a-z0-9\-]+/i', '-', $slug)));

        // ✅ Skip if not in allowed list
        if (!in_array($slug, $allowed, true)) continue;

        // Build full link
        $url = SITE_URL . "/ott/{$slug}/";
        $ottLinks[] = '<a href="' . htmlspecialchars($url) . '">' . htmlspecialchars($name) . '</a>';
    }

    // ✅ Wrap in <span> and format cleanly
    $ottList = !empty($ottLinks)
        ? '<span class="genres">' . implode(', ', $ottLinks) . '</span>'
        : '<span class="genres"></span>';
} else {
    $ottList = '<span class="genres"></span>';
}

$episodes = $data['episodes'] ?? [];
$total_ep =  $tmdb['dub'] ?? [];


$randomMovieApi = BASE_API_URL . "/random?limit=10&type=movie";

// ---- FUNCTION TO FETCH API ----
function fetchRandom($url) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);
    return $data['data'] ?? [];
}

// ---- FETCH ----
$randomMovieList = fetchRandom($randomMovieApi);
?>
<?php
// Detect URL pattern safely
$requestUri = strtok($_SERVER['REQUEST_URI'], '?'); // strip query params

$id = null;
$ep = null;
$isMovie = false;

// ✅ /episode/<slug>-1x<ep>/
if (preg_match('#/episode/([^/]+)-1x(\d+)/?#', $requestUri, $matches)) {
    $id = $matches[1];
    $ep = (int)$matches[2];
}
// ✅ /movies/<slug>/
elseif (preg_match('#/movies/([^/]+)/?#', $requestUri, $matches)) {
    $id = $matches[1];
    $ep = 1; // default for movies
    $isMovie = true;
} else {
    http_response_code(404);
    die("<p>Invalid URL format.</p>");
}

// ✅ Build safe API URL
$apiBase = rtrim(SITE_URL, '/');
$apiUrl = $apiBase . "/api/sources.php?id=" . urlencode($id) . "&ep=" . urlencode($ep);

// ✅ Fetch API data
$response = @file_get_contents($apiUrl);
if (!$response) {
    http_response_code(502);
    die("<p>Failed to connect to API.</p>");
}

$data = json_decode($response, true);
if (empty($data) || !isset($data['status']) || $data['status'] !== 'success') {
    http_response_code(404);
    die("<p>No valid data found for this content.</p>");
}

// ✅ Extract fields
$sources = $data['sources'] ?? [];
$downloads = $data['downloads'] ?? [];
$title = htmlspecialchars($data['title'] ?? 'Unknown Title');
$image = htmlspecialchars($data['image'] ?? '');
$type = htmlspecialchars($data['type'] ?? ($isMovie ? 'movie' : 'series'));
?>
<!doctype html>
<html lang="en-US" prefix="og: https://ogp.me/ns#">
   <head>
      <!--meta.php-->
      <title>Watch <?= $title ?> Online Free in HD – <?= $language ?> - Toonstream</title>
<meta name="description" content="Watch <?= $title ?> online for free in HD on ToonStream. Available in <?= $language ?> More dubbed versions. Stream or Download now!"/>
<meta property="og:title" content="Watch <?= $title ?> Online Free in HD – <?= $language ?> - Toonstream" />
<meta property="og:description" content="Watch <?= $title ?> online for free in HD on ToonStream. Available in <?= $language ?> More dubbed versions. Stream or Download now!" />
<meta property="article:tag" content="<?= $title ?>" />
<meta name="twitter:title" content="Watch <?= $title ?> Online Free in HD – <?= $language ?> - Toonstream" />
<metaname="twitter:description" content="Watch <?= $title ?> online for free in HD on ToonStream. Available in <?= $language ?> More dubbed versions. Stream or Download now!" />
      <?php
         require_once ROOT_PATH . '/components/meta.php'
         ?>

<!-- jQuery (required for OwlCarousel) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Owl Carousel JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

<link rel='stylesheet' id='wpo_min-header-0-css' href='https://toonstream.love/wp-content/cache/wpo-minify/1749135660/assets/wpo-minify-header-89ef3e2c.min.css' type='text/css' media='all' />

   </head>
   <body class="wp-singular movies-template-default single single-movies postid-5879 wp-custom-logo wp-theme-torofilm side-right login-off ">
      <div id="aa-wp" class="cont">
      <?php
         require_once ROOT_PATH . '/components/header.php'
         ?>
      
      
      <?php
         require_once ROOT_PATH . '/components/details.php'
         ?>
      
      
      
         <?php
            require_once ROOT_PATH . '/components/player.php'
            ?>
         
         






         
         
         <?php
            require_once ROOT_PATH . '/components/comment-section.php'
            
            ?> 
         
         
         
         
         
         </div>
         <div class="bghd"><img loading="lazy" class="TPostBg" src="<?= $backdrop ?>" alt="Background"></div>
         <div class="bgft"><img loading="lazy" class="TPostBg" src="<?= $backdrop ?>" alt="Background"></div>
         
         
         <?php
            require_once ROOT_PATH . '/components/related-movie.php'
            
            ?>   
         <!--footer.php-->
         <?php
            require_once ROOT_PATH . '/components/footer.php'
            
            ?>
      
      </div>


<script>
$(document).ready(function(){
  const owl = $('.owl-carousel');

  owl.owlCarousel({
    loop: false,
    margin: 8,
    nav: true,
    dots: true,
    responsive: {
      0: { items: 2 },
      576: { items: 3 },
      768: { items: 4 },
      1200: { items: 6 },
      1600: { items: 8 }
    }
  });

  function adjustNavElements() {
    if (window.innerWidth < 1200) {
      $('.owl-nav').addClass('mobile-nav').removeClass('desktop-nav');
      $('.owl-prev, .owl-next').hide(); // hide navigation buttons
    } else {
      $('.owl-nav').addClass('desktop-nav').removeClass('mobile-nav');
      $('.owl-prev, .owl-next').show(); // show them back
    }
  }

  // Initial call
  adjustNavElements();

  // On resize
  $(window).on('resize', adjustNavElements);
});
</script>

<script>
document.addEventListener("DOMContentLoaded", () => {
  // Open modal
  document.querySelectorAll("[data-mdl]").forEach(btn => {
    btn.addEventListener("click", e => {
      const mdlId = btn.getAttribute("data-mdl");
      const modal = document.getElementById(mdlId);
      if (modal) {
        modal.classList.add("on");
        document.body.style.overflow = "hidden"; // disable scroll
      }
    });
  });

  // Close modal on overlay or close button
  document.querySelectorAll(".mdl-ovr, .mdl-close").forEach(el => {
    el.addEventListener("click", () => {
      const mdlId = el.getAttribute("data-mdl");
      const modal = document.getElementById(mdlId);
      if (modal) {
        modal.classList.remove("on");
        document.body.style.overflow = ""; // re-enable scroll

        // Stop video when closing (important)
        const iframe = modal.querySelector("iframe");
        if (iframe) {
          const src = iframe.src;
          iframe.src = src; // reset to stop playback
        }
      }
    });
  });
});
</script>


   </body>
</html>
<?php if (!empty($embedUrl)): ?>
<div class="mdl" id="mdl-trailer">
   <div class="mdl-cn anm-b">
      <div class="video video-trailer">
         <iframe width="560" height="315"
                 src="<?= htmlspecialchars($embedUrl) ?>"
                 frameborder="0"
                 allow="encrypted-media; fullscreen"
                 allowfullscreen></iframe>
      </div>
      <button class="btn lnk mdl-close aa-mdl" data-mdl="mdl-trailer" type="button">
         <i class="fa-times"></i>
      </button>
   </div>
   <div class="mdl-ovr aa-mdl" data-mdl="mdl-trailer"></div>
</div>
<?php endif; ?>
	
<div class="mdl" id="mdl-favorites">
   <div class="mdl-cn anm-b">
   </div>
   <div class="mdl-ovr aa-mdl" data-mdl="mdl-favorites"></div>
</div>