<?php
require_once __DIR__ . '/../config.php';

// ✅ Make sure BASE_API_URL exists (to prevent Fatal Error)
if (!defined('BASE_API_URL')) {
    define('BASE_API_URL', rtrim(API_URL, '/'));
}

// Pagination setup
$page  = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$limit = 24;

// Get language slug from query (set by rewrite rule)
$languageName  = $_GET['id'] ?? ''; // e.g. netflix
$cleanlanguage = preg_replace('/[^a-z0-9\-]+/i', '-', strtolower(trim($languageName)));

// Build API URL
$apiUrl = BASE_API_URL . "/language/?query=" . urlencode($cleanlanguage) . "&page={$page}&limit={$limit}";

// Initialize defaults
$errorMessage  = '';
$searchResults = [];
$currentPage   = $page;
$totalPages    = 1;
$totalCount    = 0;

// Fetch data
try {
    $response = @file_get_contents($apiUrl);
    if ($response !== false) {
        $data = json_decode($response, true);
        if (!empty($data['status']) && $data['status'] === 'success' && !empty($data['data'])) {
            $searchResults = $data['data'];
            $currentPage   = $data['current_page'] ?? $page;
            $totalPages    = $data['total_pages'] ?? 1;
            $totalCount    = $data['count'] ?? 0;
        } else {
            $errorMessage = 'No results found for this language.';
        }
    } else {
        $errorMessage = 'Unable to connect to API.';
    }
} catch (Exception $e) {
    $errorMessage = 'Error: ' . $e->getMessage();
}

// Image constants
if (!defined("TMDB_POSTER_BASE")) define("TMDB_POSTER_BASE", "https://image.tmdb.org/t/p/w500");
if (!defined("TMDB_BACKDROP_BASE")) define("TMDB_BACKDROP_BASE", "https://image.tmdb.org/t/p/w1280");

// Random blocks (optional)
$randomSeriesApi = BASE_API_URL . "/random?limit=6&type=series";
$randomMoviesApi = BASE_API_URL . "/random?limit=6&type=movie";

function fetchRandom($url) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);
    return $data['data'] ?? [];
}

$randomSeriesList = fetchRandom($randomSeriesApi);
$randomMovieList  = fetchRandom($randomMoviesApi);
?>

<!doctype html>
<html lang="en-US" prefix="og: https://ogp.me/ns#">
   <head>
       <title><?= $cleanlanguage ?> - Toonstream</title>
<meta name="twitter:title" content="<?= $cleanlanguage ?> - Toonstream" />
<meta property="og:title" content="<?= $cleanlanguage ?> - Toonstream" />
<meta name="twitter:label1" content="Series" />
    
      <?php require_once ROOT_PATH . '/components/meta.php'; ?>
   </head>
   <body class="archive post-type-archive post-type-archive-movies wp-custom-logo wp-theme-torofilm side-right login-off">
      <div id="aa-wp" class="cont">
         <?php require_once ROOT_PATH . '/components/header.php'; ?>

         <div class="bd">
            <div class="dfxc">
               <main class="main-site">
                  <section class="section movies">
                     <header class="section-header">
                        <div class="rw alg-cr jst-sb">
                        <?php
                            // Set default title
                            $sectionTitle = 'All Shows';
                        
                            // Use language name from URL for title
                            if (!empty($cleanlanguage)) {
                                $sectionTitle = 'Language: ' . ucwords(str_replace(['-', '_'], ' ', $cleanlanguage));
                            }
                        ?>
                        <h1 class="section-title">
                            <?= htmlspecialchars($sectionTitle) ?>
                            <?php if ($totalCount > 0): ?>
                                <small>(<?= $totalCount ?> Results)</small>
                            <?php endif; ?>
                        </h1>

                        </div>

                        <!--<ul class="aa-tbs cat-t">-->
                        <!--   <li><a data-type="1" data-post="movies-series" href="/category/cartoon/" class="on">All</a></li>-->
                        <!--   <li><a data-category="63" data-type="1" data-post="movies" href="/category/cartoon/?type=movies">Movies</a></li>-->
                        <!--   <li><a data-category="63" data-type="1" data-post="series" href="/category/cartoon/?type=series">Series</a></li>-->
                        <!--   <li><a data-category="63" data-type="1" data-post="post" href="/category/cartoon/?type=post">News</a></li>-->
                        <!--</ul>-->
                     </header>

                     <div class="aa-cn" id="aa-movies">
                        <div id="movies-a" class="aa-tb hdd on">
                           <ul class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl6e">
<?php if (!empty($searchResults)): ?>
    <?php foreach ($searchResults as $item): ?>
        <?php
            $tmdb   = $item['tmdb'] ?? [];
            $title  = htmlspecialchars($tmdb['title'] ?? 'Unknown');
            $poster = !empty($tmdb['poster'])
                ? TMDB_POSTER_BASE . $tmdb['poster']
                : '/assets/no-image.jpg';
            $rating = isset($tmdb['rating'])
                ? round($tmdb['rating'], 1)
                : 'N/A';
            $type   = $tmdb['type'] ?? 'unknown';

            // ✅ Ensure proper URL slug: "movie" → "movies"
            $typeSlug = ($type === 'movie') ? 'movies' : $type;

            // ✅ Build clean URL
            $url = '/' . htmlspecialchars($typeSlug) . '/' . htmlspecialchars($tmdb['url'] ?? '#');
        ?>
                                    <li class="post <?= htmlspecialchars($type) ?>">
                                       <article class="post dfx fcl <?= htmlspecialchars($type) ?>">
                                          <header class="entry-header">
                                             <h2 class="entry-title"><?= $title ?></h2>
                                             <div class="entry-meta">
                                                <span class="vote"><span>TMDB</span> <?= $rating ?></span>
                                             </div>
                                          </header>
                                          <div class="post-thumbnail or-1">
                                             <figure>
                                                <img loading="lazy" src="<?= $poster ?>" alt="Image <?= $title ?>">
                                             </figure>
                                             <span class="watch btn sm">View <?= ucfirst($type) ?></span>
                                             <span class="play fa-play"></span>
                                          </div>
                                          <a href="<?= $url ?>" class="lnk-blk"></a>
                                       </article>
                                    </li>
                                 <?php endforeach; ?>
                              <?php else: ?>
                                 <p style="text-align:center;">No results found.</p>
                              <?php endif; ?>
                           </ul>
                        </div>
                     </div>

<?php if ($totalPages > 1): ?>
    <?php
    // Build clean pagination URLs
    $pageUrl = function($p) use ($cleanlanguage) {
        return "/language/" . urlencode($cleanlanguage) . "/page/" . (int)$p;
    };

    // Window setup
    $maxLinks = 3;
    $radius   = intdiv($maxLinks - 1, 2);

    // Range calculation
    $start = max(1, $currentPage - $radius);
    $end   = min($totalPages, $start + $maxLinks - 1);
    $start = max(1, min($start, $totalPages - $maxLinks + 1));
    ?>
    
    <nav class="navigation pagination">
        <div class="nav-links">

            <!-- Prev -->
            <?php if ($currentPage > 1): ?>
                <a href="<?= $pageUrl($currentPage - 1) ?>">PREV</a>
            <?php endif; ?>

            <!-- First + ellipsis -->
            <?php if ($start > 1): ?>
                <a class="page-link" href="<?= $pageUrl(1) ?>">1</a>
                <?php if ($start > 2): ?>
                    <a class="extend" href="javascript:void(0)">...</a>
                <?php endif; ?>
            <?php endif; ?>

            <!-- Number window -->
            <?php for ($i = $start; $i <= $end; $i++): ?>
                <a class="page-link <?= $i === $currentPage ? 'current' : '' ?>" href="<?= $pageUrl($i) ?>"><?= $i ?></a>
            <?php endfor; ?>

            <!-- Last + ellipsis -->
            <?php if ($end < $totalPages): ?>
                <?php if ($end < $totalPages - 1): ?>
                    <a class="extend" href="javascript:void(0)">...</a>
                <?php endif; ?>
                <a class="page-link" href="<?= $pageUrl($totalPages) ?>"><?= $totalPages ?></a>
            <?php endif; ?>

            <!-- Next -->
            <?php if ($currentPage < $totalPages): ?>
                <a href="<?= $pageUrl($currentPage + 1) ?>">NEXT</a>
            <?php endif; ?>

        </div>
    </nav>
<?php endif; ?>


                  </section>
               </main>
               <aside class="sidebar">
                  <div>
                     
                     
                                      <!--siderbar.php-->
                                              <?php
require_once ROOT_PATH . '/components/sidebar.php'

?>
                     
                     
                  </div>
               </aside>
            </div>

         <?php
            require_once ROOT_PATH . '/components/footer.php'
            
            ?>
            <!--<div class="bghd"><img loading="lazy" src="/public/img/one-piece-live.jpg"></div>-->
         <div class="bgft"><img loading="lazy" src="/public/img/poster.jpg"></div>

   </body>
</html>