<?php
require_once __DIR__ . '/../config.php';

// Validate config constant
if (!defined('API_URL')) {
    die("Error: API_URL not defined in config.php");
}

// API URL setup
define('BASE_API_URL', rtrim(API_URL, '/'));
$endpoint = '/home';
$apiUrl = BASE_API_URL . $endpoint;

// Fetch API data
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $apiUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 10,
    CURLOPT_FOLLOWLOCATION => true,
]);
$response = curl_exec($ch);

// Handle curl and HTTP errors
if (curl_errno($ch)) {
    die('cURL error: ' . curl_error($ch));
}
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode !== 200) {
    die("API returned HTTP $httpCode");
}

// Decode JSON
$data = json_decode($response, true);
if (!is_array($data)) {
    die("API response invalid or empty");
}

// Assign arrays
$topAiringData = $data['top_airing'] ?? [];
$popularData   = $data['popular'] ?? [];
$ongoingData   = $data['ongoing'] ?? [];
$completeData  = $data['completed'] ?? [];
$latestAnimes  = $data['latest'] ?? [];
$latestMovie   = $data['movie'] ?? [];
$latestSeries  = $data['series'] ?? [];
$top10Today    = $data['top10']['today'] ?? [];
$top10Week     = $data['top10']['week'] ?? [];
$top10Month    = $data['top10']['month'] ?? [];

// ---- API ENDPOINTS ----
$randomSeriesApi = BASE_API_URL . "/random?limit=6&type=series";
$randomMoviesApi = BASE_API_URL . "/random?limit=6&type=movie";

// ---- FUNCTION TO FETCH API ----
function fetchRandom($url) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);
    return $data['data'] ?? []; // return full array of items
}

// ---- FETCH BOTH ----
$randomSeriesList = fetchRandom($randomSeriesApi);
$randomMovieList  = fetchRandom($randomMoviesApi);

$filteredLatestAnimes = [];

// ---- Filter Only Series and Prepare Data ----
foreach ($latestAnimes as $anime) {
    $tmdb = $anime['tmdb'] ?? [];
    $updated = $anime['updated'] ?? null; 
    if (($tmdb['type'] ?? '') !== 'series') continue; // ✅ Only series

    $tmdbId  = $tmdb['tmdb_id'] ?? null;
    $title   = trim($tmdb['title'] ?? '');
    $season  = (int)($tmdb['season'] ?? 1);
    $org_slug = $tmdb['url'] ?? null;
    $episode = (int)($tmdb['dub'] ?? $tmdb['sub'] ?? 1); // prefer dub, else sub

    if (!$tmdbId || !$title) continue;

    $filteredLatestAnimes[] = [
        'tmdb_id' => $tmdbId,
        'title'   => $title,
        'season'  => $season,
        'episode' => $episode,
        'tmdb'    => $tmdb,
        'org_slug' => $org_slug,
        'updated' => $updated, // ✅ store updated date here
    ];
}

// ---- Helper: TMDB Image URL Builder ----
function tmdb_image_url(?string $path, string $size = 'w185'): ?string {
    if (empty($path)) return null;
    if ($path[0] !== '/') $path = '/' . $path;
    return "https://image.tmdb.org/t/p/{$size}{$path}";
}

// ---- Helper: Convert Updated Date to “Time Ago” ----
function timeAgoIST(?string $dateString): string {
    if (empty($dateString)) return "Recently";

    $tz = new DateTimeZone('Asia/Kolkata');
    $updated = DateTime::createFromFormat('d-m-Y', $dateString, $tz);
    if (!$updated) return "Recently";

    $now = new DateTime('now', $tz);
    $diff = $now->diff($updated);

    // If the updated date is in the future → just say “Recently”
    if ($updated > $now) return "Recently";

    if ($diff->y > 0) return $diff->y . " year" . ($diff->y > 1 ? "s" : "") . " ago";
    if ($diff->m > 0) return $diff->m . " month" . ($diff->m > 1 ? "s" : "") . " ago";
    if ($diff->d > 0) return $diff->d . " day" . ($diff->d > 1 ? "s" : "") . " ago";
    if ($diff->h > 0) return $diff->h . " hour" . ($diff->h > 1 ? "s" : "") . " ago";
    if ($diff->i > 0) return $diff->i . " minute" . ($diff->i > 1 ? "s" : "") . " ago";
    return "Just now";
}

// ---- Fetch image from ToonStream API ----
function fetchToonstreamImage($tmdbId, $season, $episode) {
    $url = BASE_API_URL . "/toonstream/all?tmdb_id={$tmdbId}&season={$season}&episode={$episode}";
    $ch = curl_init();

    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 8,
        CURLOPT_CONNECTTIMEOUT => 4,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_USERAGENT => 'ToonstreamFetcher/1.0',
    ]);

    $response = curl_exec($ch);
    $err  = curl_error($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($err || $code !== 200 || !$response) {
        error_log("❌ ToonStream fetch failed for TMDB {$tmdbId} (HTTP {$code}): {$err}");
        return null;
    }

    $data = json_decode($response, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("❌ JSON decode failed for TMDB {$tmdbId}");
        return null;
    }

    $image = $data['image'] ?? null;

    // ✅ Ignore placeholder images
    if ($image && str_contains($image, 'noimg-episode.png')) {
        $image = null;
    }

    // ✅ Convert /original/ → /w185/ for optimization
    if ($image && strpos($image, '/original/') !== false) {
        $image = str_replace('/original/', '/w185/', $image);
    }

    return $image;
}

// ---- Enrich Anime List with Smart Fallbacks ----
$latestAnimeWithImages = [];
$maxRequests = 6;
$counter = 0;

foreach ($filteredLatestAnimes as $anime) {
    if (++$counter > $maxRequests) break;

    $tmdb = $anime['tmdb'] ?? [];

    // Step 1: ToonStream image (ignore placeholder)
    $img = fetchToonstreamImage($anime['tmdb_id'], $anime['season'], $anime['episode']);

    // Step 2: Fallback — TMDB backdrop
    if (!$img && !empty($tmdb['backdrop'])) {
        $img = tmdb_image_url($tmdb['backdrop']);
    }

    // Step 3: Fallback — TMDB poster
    if (!$img && !empty($tmdb['poster'])) {
        $img = tmdb_image_url($tmdb['poster']);
    }

    // Step 4: Fallback — Default
    if (!$img) {
        $img = '/assets/no-image.jpg';
    }

    $latestAnimeWithImages[] = [
        'tmdb_id' => $anime['tmdb_id'],
        'title'   => $anime['title'],
        'season'  => $anime['season'],
        'episode' => $anime['episode'],
        'org_slug' => $anime['org_slug'],
        'image'   => $img,
        'updated' => $anime['updated'] ?? null, // ✅ keep updated field
    ];

    usleep(150000); // 0.15s delay per request
}



?>



<!doctype html>
<html lang="en-US" prefix="og: https://ogp.me/ns#">
   <head>
      
<!--meta.php-->
<title>ToonStream – India’s Home for Multi-Language Anime Streaming
Watch the latest anime episodes, classics, and exclusive movies in Hindi, Tamil, Telugu, and English. Stream or download instantly with fast servers and high-quality playback.From action-packed shonen to romance, fantasy, and slice-of-life, ToonStream gives you anime in the language you prefer—anytime, anywhere.</title>
<meta name="description" content="Watch or download anime in Hindi, Tamil, Telugu, and English on ToonStream. Stream latest episodes, classic shows, and anime movies for free with fast, high-quality playback." />
<meta name="twitter:title" content="ToonStream – India’s Home for Multi-Language Anime Streaming
Watch the latest anime episodes, classics, and exclusive movies in Hindi, Tamil, Telugu, and English. Stream or download instantly with fast servers and high-quality playback. From action-packed shonen to romance, fantasy, and slice-of-life, ToonStream gives you anime in the language you prefer—anytime, anywhere." />
<meta property="og:title" content="ToonStream – India’s Home for Multi-Language Anime Streaming
Watch the latest anime episodes, classics, and exclusive movies in Hindi, Tamil, Telugu, and English. Stream or download instantly with fast servers and high-quality playback.From action-packed shonen to romance, fantasy, and slice-of-life, ToonStream gives you anime in the language you prefer—anytime, anywhere." />
<meta name="twitter:description" content="Watch or download anime in Hindi, Tamil, Telugu, and English on ToonStream. Stream latest episodes, classic shows, and anime movies for free with fast, high-quality playback." />
<meta property="og:description" content="Stream or Download anime in Hindi, Tamil, Telugu, and English dubs on ToonStream. Enjoy the latest episodes and timeless classics for free" />

    
      <?php
            require_once ROOT_PATH . '/components/meta.php'
            ?>
<script type="application/ld+json" class="rank-math-schema">{"@context":"https://schema.org","@graph":[{"@type":"Person","@id":"<?= SITE_URL ?>/#person","name":"Toonstream","url":"<?= SITE_URL ?>","image":{"@type":"ImageObject","@id":"<?= SITE_URL ?>/#logo","url":"<?= SITE_URL ?>/public/img/favicon.png","contentUrl":"<?= SITE_URL ?>/public/img/favicon.png","caption":"Toonstream","inLanguage":"en-US","width":"112","height":"112"}},{"@type":"WebSite","@id":"<?= SITE_URL ?>/#website","url":"<?= SITE_URL ?>","name":"Toonstream","alternateName":"toon stream, toon, anime-world","publisher":{"@id":"<?= SITE_URL ?>/#person"},"inLanguage":"en-US","potentialAction":{"@type":"SearchAction","target":"<?= SITE_URL ?>/?s={search_term_string}","query-input":"required name=search_term_string"}},{"@type":"CollectionPage","@id":"<?= SITE_URL ?>/#webpage","url":"<?= SITE_URL ?>/","name":"ToonStream – India’s Home for Multi-Language Anime Streaming Watch the latest anime episodes, classics, and exclusive movies in Hindi, Tamil, Telugu, and English. Stream or download instantly with fast servers and high-quality playback. From action-packed shonen to romance, fantasy, and slice-of-life, ToonStream gives you anime in the language you prefer—anytime, anywhere.","about":{"@id":"<?= SITE_URL ?>/#person"},"isPartOf":{"@id":"<?= SITE_URL ?>/#website"},"inLanguage":"en-US"}]}</script>            
     <style>
         .hd .logo img
         {
          display: none;
        }
        
        @media (max-width: 992px) {
          .search > .btn,
          .hd .logo img,
          .hd .search input {
            display: inline-block; 
          }
        }
         
     </style>
   </head>
   <body class="home blog wp-custom-logo wp-theme-torofilm side-right login-off ">
      <div id="aa-wp" class="cont">
          
<!--header.php-->
<?php
require_once ROOT_PATH . '/components/header.php'
?>
         <div class="bd">
            <div class="home-search hdd shwc">
               <figure class="logo tac"><img src="<?= SITE_URL ?>/public/img/sitename/TOONSTREAM.png"></figure>
               <form id="form-shs" class="search full" method="get" action="<?= SITE_URL ?>">
                  <input id="tr_live_search" name="s" type="text" placeholder="Search">
                  <button type="submit" class="btn npd lnk"><i id="sl-home" class="fa-search"></i></button>
                  <ul id="res-sj" class="sub-menu"></ul>
               </form>
            </div>
            <div class="dfxc">
               <main class="main-site">
                   
<?php
require_once ROOT_PATH . '/components/anime-card.php'
?>

                  <section id="block-49" class="wdgt-home widget section widget_block">
                     <div class="search-in-place-box-container  ">
                        <form  class="search full" method="get" action="<?= SITE_URL ?>">
                           <input  type="text" name="s" data-search-in-place="1" placeholder="">
                           <button type="submit" class="btn npd lnk">
                           <i id="sl_home_h" class="fa-search"></i>
                           </button>
                           <input type="hidden" name="search_in_place_form" value="1">
                        </form>
                     </div>
                  </section>
                  <section id="block-53" class="wdgt-home widget section widget_block">
                     <h4 style="text-align: center;"><a href="<?= TELEGRAM ?>"><img decoding="async" class="aligncenter" src="<?= SITE_URL ?>/public/img/image.png"></a></h4>
                  </section>
                  <!--<section id="block-60" class="wdgt-home widget section widget_block">-->
                  <!--   <div class="wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-16018d1d wp-block-buttons-is-layout-flex">-->
                        <!--<div class="wp-block-button is-style-outline is-style-outline--1"><a class="wp-block-button__link wp-element-button" href=""><strong><strong><sup>Check Out Our New Hindi Dub Anime</sup></strong></strong></a></div>-->
                  <!--   </div>-->
                  <!--</section>-->
                  
                 <!--new-episde-list.php-->
                  <?php
require_once ROOT_PATH . '/components/save-slider.php'

?>                

                 <?php
require_once ROOT_PATH . '/components/new-episode-list.php'

?>


<!--series.php-->
                                  <?php
require_once ROOT_PATH . '/components/latest-series.php'

?>            
                 <!--movie.php-->
                             <?php
require_once ROOT_PATH . '/components/latest-movie.php'

?>
     
                                  <?php
require_once ROOT_PATH . '/components/a2z-list.php'

?>
     
               </main>
               <aside class="sidebar">
                  <div>
                     <!--<section id="block-67" class="wdgt-sidebar widget widget_block">-->
                     <!--   <div id="pf-15543-1" data-format="mixed" data-lazy="false">-->
                     <!--      <script>window.pubfuturetag = window.pubfuturetag || [];window.pubfuturetag.push({unit: "6850f3b4fbfef347df4d72c9", id: "pf-15543-1"})</script>-->
                     <!--   </div>-->
                     <!--</section>-->
                     <!--<section id="block-63" class="wdgt-sidebar widget widget_block">-->
                     <!--   <script async data-cfasync="false" data-size="300x250" data-category="anime" data-id="dl-banner-300x250" data-zone="9324000" src="//koaptouw.com/btag.min.js"></script>-->
                     <!--</section>-->
                 
                 
                 <!--siderbar.php-->
                                              <?php
require_once ROOT_PATH . '/components/sidebar.php'

?>
                 
            </div>
         </div>
         
         <!--footer.php-->
                                                       <?php
require_once ROOT_PATH . '/components/footer.php'

?>
            <!--<div class="bghd"><img loading="lazy" src="/public/img/one-piece-live.jpg"></div>-->
         <div class="bgft"><img loading="lazy" src="/public/img/poster.jpg"></div>
      <!-- modal -->
  
     
<style id="block-style-variation-styles-inline-css" type="text/css">
  :root :where(.wp-block-button.is-style-outline--1 .wp-block-button__link) {
    background: transparent none;
    border-color: currentColor;
    border-width: 2px;
    border-style: solid;
    color: currentColor;
    padding-top: 0.667em;
    padding-right: 1.33em;
    padding-bottom: 0.667em;
    padding-left: 1.33em;
  }

  .post-thumbnail .year {
    background-color: black !important;
  }
</style>

      <style id='core-block-supports-inline-css' type='text/css'>
         .wp-container-core-buttons-is-layout-16018d1d{justify-content:center;}
      </style>
      <script>
function toggleSearchForm() {
  const searchForm = document.querySelector('.search.full');

  if (!searchForm) return;

  if (window.innerWidth >= 992) {
    searchForm.style.display = 'none';
  } else {
    searchForm.style.display = 'block'; 
  }
}

// Run once on load
window.addEventListener('DOMContentLoaded', toggleSearchForm);

// Run on resize
window.addEventListener('resize', toggleSearchForm);
</script>
 
 </body>
</html>