<?php
   require_once __DIR__ . '/../config.php';
   
   // ✅ Check for ID parameter
if (empty($_GET['id'])) {
    die("Error: Missing ID parameter in URL.");
}

$id_raw = trim($_GET['id']);  // full slug from URL
$season = null;
$episode = null;

// 🔹 Match patterns like "-1x3", "-01x03", "-2x12", etc.
if (preg_match('/-(\d+)x(\d+)$/i', $id_raw, $matches)) {
    $season = (int)$matches[1];
    $episode = (int)$matches[2];
}

// 🔹 Remove the trailing "-1x3" part to get the clean base ID
$id = preg_replace('/-\d+x\d+$/i', '', $id_raw);

// ✅ Build API URL dynamically
define('BASE_API_URL', rtrim(API_URL, '/'));
$apiUrl = BASE_API_URL . '/details/?id=' . urlencode($id);

// ✅ Fetch data
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $apiUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 15,
    CURLOPT_FOLLOWLOCATION => true,
]);
$response = curl_exec($ch);

if (curl_errno($ch)) {
    die("cURL Error: " . curl_error($ch));
}

$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode !== 200) {
    die("API returned HTTP $httpCode");
}

// ✅ Decode JSON
$json = json_decode($response, true);
if (!is_array($json) || empty($json['data'])) {
    die("Invalid API response");
}

$data = $json['data'];

// Extract TMDB info
$tmdb = $data['tmdb'] ?? [];
$language = $data['languages'] ?? "N/A Language";
if (!empty($data['languages'])) {
    $languageLinks = [];

    // Break "Hindi-English-Japanese" into an array
    foreach (explode('-', $data['languages']) as $lang) {
        $lang = trim($lang);
        if ($lang === '') continue;

        // Build clean slug and link
        $slug = strtolower(preg_replace('/[^a-z0-9]+/i', '-', $lang));
        $url = SITE_URL . "/language/{$slug}/";
        $languageLinks[] = '<a href="' . htmlspecialchars($url) . '">' . htmlspecialchars($lang) . '</a>';
    }

    $language_link = implode(', ', $languageLinks);
} else {
    $language_link = 'N/A Language';
}

$title = htmlspecialchars($tmdb['title'] ?? 'N/A Title');
$poster = !empty($tmdb['poster']) ? 'https://image.tmdb.org/t/p/w500' . $tmdb['poster'] : '/assets/no-image.jpg';
$backdrop = !empty($tmdb['backdrop'])
    ? 'https://image.tmdb.org/t/p/original' . $tmdb['backdrop']
    : (!empty($tmdb['poster']) ? 'https://image.tmdb.org/t/p/original' . $tmdb['poster'] : '');
  
$overview = htmlspecialchars($tmdb['overview'] ?? 'No description available.');
$rating = $tmdb['rating'] ?? 'N/A';
$releaseYear = $tmdb['release_year'] ?? 'N/A';
$season = $tmdb['season'] ?? 'N/A';
$runtime = $tmdb['episode_runtime'] ?? null;

// ensure runtime is numeric and valid
if (is_numeric($runtime) && $runtime > 0) {
    $hours = floor($runtime / 60);
    $minutes = $runtime % 60;

    if ($hours > 0 && $minutes > 0) {
        $runtime = "{$hours}h {$minutes}";
    } elseif ($hours > 0) {
        $runtime = "{$hours}h";
    } else {
        $runtime = "{$minutes}";
    }
} else {
    $runtime = ''; // empty if invalid
}

if (!empty($tmdb['genre'])) {
    $genreLinks = [];
    $genres = array_slice($tmdb['genre'], 0, 10); // limit to 10 items max

    foreach ($genres as $genre) {
        $slug = strtolower(trim(preg_replace('/[^a-z0-9]+/i', '-', $genre)));
        $url = SITE_URL . "/genre/" . $slug . "/";
        $genreLinks[] = '<a href="' . htmlspecialchars($url) . '">' . htmlspecialchars($genre) . '</a>';
    }

    $genreList = implode(', ', $genreLinks);
} else {
    $genreList = 'Unknown';
}

$trailers = $tmdb['trailers'] ?? [];

if (!empty($trailers)) {
    // Pick first trailer (or show multiple if you want)
    $firstTrailer = $trailers[0]['url'] ?? '';

    // Convert normal YouTube URL → embed format
    if (preg_match('/(?:v=|youtu\.be\/)([A-Za-z0-9_-]{11})/', $firstTrailer, $matches)) {
        $videoId = $matches[1];
        $embedUrl = "https://www.youtube.com/embed/" . $videoId;
    } else {
        $embedUrl = ''; // fallback
    }
}
if (!empty($tmdb['ott']) && is_array($tmdb['ott'])) {
    $ottLinks = [];

    // ✅ Only allow these platforms
    $allowed = ['netflix', 'crunchyroll', 'disney-plus', 'amazon-video'];

    foreach ($tmdb['ott'] as $name => $slug) {
        // Clean slug
        $slug = strtolower(trim(preg_replace('/[^a-z0-9\-]+/i', '-', $slug)));

        // ✅ Skip if not in allowed list
        if (!in_array($slug, $allowed, true)) continue;

        // Build full link
        $url = SITE_URL . "/ott/{$slug}/";
        $ottLinks[] = '<a href="' . htmlspecialchars($url) . '">' . htmlspecialchars($name) . '</a>';
    }

    // ✅ Wrap in <span> and format cleanly
    $ottList = !empty($ottLinks)
        ? '<span class="genres">' . implode(', ', $ottLinks) . '</span>'
        : '<span class="genres">Not Available</span>';
} else {
    $ottList = '<span class="genres">Not Available</span>';
}

$episodes = $data['episodes'] ?? [];
$total_ep =  $episode;

$randomSeriesApi = BASE_API_URL . "/random?limit=10&type=series";

// ---- FUNCTION TO FETCH API ----
function fetchRandom($url) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);
    return $data['data'] ?? [];
}

// ---- FETCH ----
$randomSeriesList = fetchRandom($randomSeriesApi);


$episodeImages = [];
$episodeList = [];

$tmdbIdValue = $tmdb['tmdb_id'] ?? $tmdb['id'] ?? null;

if (!empty($tmdbIdValue)) {
    $tmdb_id = urlencode($tmdbIdValue);
    $season = !empty($tmdb['season']) ? urlencode($tmdb['season']) : 1;

    // 🔹 Fetch episode images from toonstream API
    $imgApiUrl = BASE_API_URL . "/toonstream/img?tmdb_id={$tmdb_id}&season={$season}";
    // error_log("DEBUG IMG API: " . $imgApiUrl);

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $imgApiUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 15,
        CURLOPT_FOLLOWLOCATION => true,
    ]);
    $imgResponse = curl_exec($ch);
    curl_close($ch);

    // error_log("DEBUG IMG RESPONSE: " . substr($imgResponse, 0, 500));

    $imgJson = json_decode($imgResponse, true);
    $images = $imgJson['images'] ?? $imgJson['data'] ?? [];

    // 🔹 If valid images exist, store them
    if (
        is_array($imgJson) &&
        isset($imgJson['status']) &&
        $imgJson['status'] === 'success' &&
        !empty($images)
    ) {
        foreach ($images as $ep) {
            if (isset($ep['episode'], $ep['image'])) {
                $img = trim($ep['image']);

                // ❌ Skip default placeholder image
                if (strpos($img, 'noimg-episode.png') !== false) {
                    continue;
                }

                $episodeImages[(int)$ep['episode']] = htmlspecialchars($img);
            }
        }
    }
}

// 🔹 Build final list of unique episodes (no duplicates)
if (!empty($data['episodes']) && is_array($data['episodes'])) {

    // fallback image — TMDB backdrop or poster
    $backdrop_ep = !empty($tmdb['backdrop'])
        ? 'https://image.tmdb.org/t/p/w185' . $tmdb['backdrop']
        : (!empty($tmdb['poster'])
            ? 'https://image.tmdb.org/t/p/w185' . $tmdb['poster']
            : '/assets/no-image.jpg');

    $seenEpisodes = []; // track which episode numbers already added

    foreach ($data['episodes'] as $ep) {
        if (empty($ep['episode'])) continue;

        $episodeNum = (int)$ep['episode'];

        // skip duplicate episode numbers (multiple qualities)
        if (isset($seenEpisodes[$episodeNum])) continue;
        $seenEpisodes[$episodeNum] = true;

        

        // ✅ Fallback: if image not found → use TMDB backdrop/poster
        $image = !empty($episodeImages[$episodeNum])
            ? $episodeImages[$episodeNum]
            : $backdrop_ep;

        $episodeList[] = [
            'season'  => (int)($tmdb['season'] ?? 1),
            'episode' => $episodeNum,
            'image'   => htmlspecialchars($image),
        ];
    }
}



$seasonList = [];

if (!empty($tmdbIdValue)) {
    $seriesUrl = BASE_API_URL . "/season/" . urlencode($tmdbIdValue);
    $seriesResponse = @file_get_contents($seriesUrl);

    // error_log("DEBUG SERIES URL: " . $seriesUrl);
    // error_log("DEBUG SERIES RESPONSE: " . substr($seriesResponse, 0, 500));

    if ($seriesResponse !== false) {
        $seriesJson = json_decode($seriesResponse, true);

        if (!empty($seriesJson['seasons']) && is_array($seriesJson['seasons'])) {
            foreach ($seriesJson['seasons'] as $s) {
                if (!empty($s['id'])) {
                    $seasonList[] = [
                        'id'    => $s['id'],
                        'title' => $s['title'] ?? 'Season'
                    ];
                }
            }
        }
    }
}

   ?>
<?php
// Detect URL pattern safely
$requestUri = strtok($_SERVER['REQUEST_URI'], '?'); // strip query params

$id = null;
$ep = null;
$isMovie = false;

if (preg_match('#/episode/([^/]+)-(\d+)x(\d+)/?#', $requestUri, $matches)) {
    $id = $matches[1];
    $season = (int)$matches[2];
    $ep = (int)$matches[3];
}
// ✅ /movies/<slug>/ 
elseif (preg_match('#/movies/([^/]+)/?#', $requestUri, $matches)) {
    $id = $matches[1];
    $ep = 1;
    $season = 1;
    $isMovie = true;
} else {
    http_response_code(404);
    die("<p>Invalid URL format.</p>");
}

// ✅ Build safe API URL
$apiBase = rtrim(SITE_URL, '/');
$apiUrl = $apiBase . "/api/sources.php?id=" . urlencode($id) . "&ep=" . urlencode($ep);

// ✅ Fetch API data
$response = @file_get_contents($apiUrl);
if (!$response) {
    http_response_code(502);
    die("<p>Failed to connect to API.</p>");
}

$data = json_decode($response, true);
if (empty($data) || !isset($data['status']) || $data['status'] !== 'success') {
    http_response_code(404);
    die("<p>No valid data found for this content.</p>");
}

// ✅ Extract fields
$sources = $data['sources'] ?? [];
$downloads = $data['downloads'] ?? [];
$title = htmlspecialchars($data['title'] ?? 'Unknown Title');
$image = htmlspecialchars($data['image'] ?? '');
$type = htmlspecialchars($data['type'] ?? ($isMovie ? 'movie' : 'series'));
?>
<!doctype html>
<html lang="en-US" prefix="og: https://ogp.me/ns#">
   <head>
      <!--meta.php-->
      <title><?= $title ?> <?= $season ?>x<?= $total_ep ?> - Toonstream</title>
<meta name="description" content="Watch <?= $title ?> online for free in HD on ToonStream. Available in <?= $language ?>  More dubbed versions. Stream or Download now!"/>
<meta property="og:title" content="<?= $title ?> <?= $season ?>x<?= $total_ep ?> - Toonstream" />
<meta property="og:description" content="Watch online for free in HD on ToonStream. Available in <?= $language ?> More dubbed versions. Stream or Download now!" />
<meta name="twitter:title" content="<?= $title ?> <?= $season ?>x<?= $total_ep ?> - Toonstream" />
<meta name="twitter:description" content="Watch <?= $title ?> online for free in HD on ToonStream. Available in  <?= $language ?> More dubbed versions. Stream or Download now!" /
<meta name="twitter:label1" content="Series" />
      <?php
         require_once ROOT_PATH . '/components/meta.php'
         ?>

<!-- jQuery (required for OwlCarousel) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Owl Carousel JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>



   </head>
   <body class="wp-singular movies-template-default single single-movies postid-5879 wp-custom-logo wp-theme-torofilm side-right login-off ">
      <div id="aa-wp" class="cont">
      <?php
         require_once ROOT_PATH . '/components/header.php'
         ?>
      
      
      <?php
         require_once ROOT_PATH . '/components/details.php'
         ?>
      
      
      
         <?php
            require_once ROOT_PATH . '/components/player.php'
            ?>
         
         
         
         
         
         
         
         
<?php
// --- EPISODE NAVIGATION LOGIC (Auto detects) ---

// Detect current season + episode from URL
$currentSeason = (int)($season ?? $tmdb['season'] ?? 1);
$currentEpisode = (int)($episode ?? 1);

// Detect total episodes from episode list if not defined
$totalEpisodes = !empty($episodeList) ? count($episodeList) : 0;

// Compute prev / next safely
$prevEpisode = $currentEpisode > 1 ? $currentEpisode - 1 : null;
$nextEpisode = ($totalEpisodes > 0 && $currentEpisode < $totalEpisodes) ? $currentEpisode + 1 : null;

// Clean slug for safe URL use
$baseSlug = htmlspecialchars($id, ENT_QUOTES, 'UTF-8');
?>
<br>
<div class="mb-30">
  <div class="epsdsnv mab1">

    <!-- Previous Button -->
    <?php if ($prevEpisode): ?>
      <a href="/episode/<?= $baseSlug ?>-<?= $currentSeason ?>x<?= $prevEpisode ?>/"
         class="btn tertiary-bg mar">
        <i class="fa-step-backward"></i>
        <span class="ttu dn sm-dib mal">Previous</span>
      </a>
    <?php else: ?>
      <span class="btn tertiary-bg mar off">
        <i class="fa-step-backward"></i>
        <span class="ttu dn sm-dib mal">Previous</span>
      </span>
    <?php endif; ?>

    <!-- Seasons Button -->
    <a href="/series/<?= $baseSlug ?>/" class="btn tertiary-bg mar">
      <i class="fa-indent"></i>
      <span class="ttu dn sm-dib mal">Seasons</span>
    </a>

    <!-- Next Button -->
    <?php if ($nextEpisode): ?>
      <a href="/episode/<?= $baseSlug ?>-<?= $currentSeason ?>x<?= $nextEpisode ?>/"
         class="btn tertiary-bg mar">
        <span class="ttu dn sm-dib mar">Next</span>
        <i class="fa-step-forward"></i>
      </a>
    <?php else: ?>
      <span class="btn tertiary-bg mar off">
        <span class="ttu dn sm-dib mar">Next</span>
        <i class="fa-step-forward"></i>
      </span>
    <?php endif; ?>

  </div>
</div>



  <?php
            require_once ROOT_PATH . '/components/dyanmic-episode-section.php'
            
            ?> 
         






         
         
  
         
         
         
         </br> 
         
         </div>
         <div class="bghd"><img loading="lazy" class="TPostBg" src="<?= $backdrop ?>" alt="Background"></div>
         <div class="bgft"><img loading="lazy" class="TPostBg" src="<?= $backdrop ?>" alt="Background"></div>
         
         
         <?php
            require_once ROOT_PATH . '/components/recommended-series.php'
            
            ?>   
         <!--footer.php-->
         <?php
            require_once ROOT_PATH . '/components/footer.php'
            
            ?>
      
      </div>


<script>
$(document).ready(function(){
  const owl = $('.owl-carousel');

  owl.owlCarousel({
    loop: false,
    margin: 8,
    nav: true,
    dots: true,
    responsive: {
      0: { items: 2 },
      576: { items: 3 },
      768: { items: 4 },
      1200: { items: 6 },
      1600: { items: 8 }
    }
  });

  function adjustNavElements() {
    if (window.innerWidth < 1200) {
      $('.owl-nav').addClass('mobile-nav').removeClass('desktop-nav');
      $('.owl-prev, .owl-next').hide(); // hide navigation buttons
    } else {
      $('.owl-nav').addClass('desktop-nav').removeClass('mobile-nav');
      $('.owl-prev, .owl-next').show(); // show them back
    }
  }

  // Initial call
  adjustNavElements();

  // On resize
  $(window).on('resize', adjustNavElements);
});
</script>


<script>
document.addEventListener("DOMContentLoaded", () => {
  // Open modal
  document.querySelectorAll("[data-mdl]").forEach(btn => {
    btn.addEventListener("click", e => {
      const mdlId = btn.getAttribute("data-mdl");
      const modal = document.getElementById(mdlId);
      if (modal) {
        modal.classList.add("on");
        document.body.style.overflow = "hidden"; // disable scroll
      }
    });
  });

  // Close modal on overlay or close button
  document.querySelectorAll(".mdl-ovr, .mdl-close").forEach(el => {
    el.addEventListener("click", () => {
      const mdlId = el.getAttribute("data-mdl");
      const modal = document.getElementById(mdlId);
      if (modal) {
        modal.classList.remove("on");
        document.body.style.overflow = ""; // re-enable scroll

        // Stop video when closing (important)
        const iframe = modal.querySelector("iframe");
        if (iframe) {
          const src = iframe.src;
          iframe.src = src; // reset to stop playback
        }
      }
    });
  });
});
</script>

<script>
  document.addEventListener('DOMContentLoaded', () => {
    const autoNext = localStorage.getItem('auto_next') !== 'false';
    const autoSkip = localStorage.getItem('auto_skip_intro_outro') !== 'false';

    document.getElementById('autoNextToggle').checked = autoNext;
    document.getElementById('skipIntroToggle').checked = autoSkip;

    updateSliderVisual('autoNextSlider', autoNext);
    updateSliderVisual('skipIntroSlider', autoSkip);
  });

  function updateToggle(checkbox, controlId) {
    const checked = checkbox.checked;
    if (controlId === 'autoNext')
      localStorage.setItem('auto_next', checked ? 'true' : 'false');
    else if (controlId === 'autoSkip')
      localStorage.setItem('auto_skip_intro_outro', checked ? 'true' : 'false');

    updateSliderVisual(
      checkbox.id === 'autoNextToggle' ? 'autoNextSlider' : 'skipIntroSlider',
      checked
    );
  }

  function updateSliderVisual(sliderId, active) {
    const slider = document.getElementById(sliderId);
    const knob = slider?.querySelector('span');
    if (!slider || !knob) return;

    slider.style.backgroundColor = active ? 'var(--primary)' : '#ccc';
    knob.style.left = active ? '22px' : '2px';
  }

  // Send settings every second to the proxy iframe
  setInterval(() => {
    const iframe =
      document.querySelector("iframe[src*='proxy.php']") ||
      document.querySelector("iframe[src*='play.zephyrflick.top']");
    if (!iframe) return;

    const autoSkip = localStorage.getItem('auto_skip_intro_outro') !== 'false';
    const autoNext = localStorage.getItem('auto_next') !== 'false';

    let audioLang = 'hin';
    try {
      const savedAudio = JSON.parse(localStorage.getItem('selected_anime_audio') || '{}');
      if (savedAudio?.lang) audioLang = savedAudio.lang;
    } catch {}

    iframe.contentWindow.postMessage(
      {
        type: 'settings',
        autoSkip,
        autoNext,
        audioLanguage: audioLang,
      },
      '*'
    );
  }, 1000);

  // Handle completion messages (from proxy or ZephyrFlick)
  window.addEventListener('message', (event) => {
    // Accept messages from your own domain (proxy) OR ZephyrFlick
    if (
      !event.origin.includes(window.location.hostname) &&
      !event.origin.includes('play.zephyrflick.top')
    )
      return;

    const data = event.data;
    if (!data) return;

    const autoNext = localStorage.getItem('auto_next') !== 'false';

    if (
      autoNext &&
      (data === 'video_playback_completed' ||
        data?.type === 'ended' ||
        data?.event === 'ended' ||
        data?.status === 'completed')
    ) {
      triggerAutoNext();
    }
  });

  // ✅ UPDATED triggerAutoNext() - finds next button automatically
  function triggerAutoNext() {
    const autoNext = localStorage.getItem('auto_next') !== 'false';
    if (!autoNext) return;

    // Try multiple ways to find the "Next" episode link
    const nextEpLink =
      document.getElementById('next-episode') || // fallback if id exists
      document.querySelector('.epsdsnv a:has(.fa-step-forward)') || // new layout detection
      document.querySelector('.epsdsnv a .fa-step-forward')?.closest('a');

    if (nextEpLink && nextEpLink.href) {
      console.log('✅ Auto-next triggered →', nextEpLink.href);
      window.location.href = nextEpLink.href;
    } else {
      console.warn('⚠️ No next-episode link found.');
    }
  }
</script>


   </body>
</html>
<?php if (!empty($embedUrl)): ?>
<div class="mdl" id="mdl-trailer">
   <div class="mdl-cn anm-b">
      <div class="video video-trailer">
         <iframe width="560" height="315"
                 src="<?= htmlspecialchars($embedUrl) ?>"
                 frameborder="0"
                 allow="encrypted-media; fullscreen"
                 allowfullscreen></iframe>
      </div>
      <button class="btn lnk mdl-close aa-mdl" data-mdl="mdl-trailer" type="button">
         <i class="fa-times"></i>
      </button>
   </div>
   <div class="mdl-ovr aa-mdl" data-mdl="mdl-trailer"></div>
</div>
<?php endif; ?>


<!--<div class="mdl on" id="mdl-trailer">-->
<!--		<div class="mdl-cn anm-b">-->
<!--			<div class="video">-->
<!--				<iframe width="560" height="315" src="https://www.youtube.com/embed/GICvY-T6nKs" frameborder="0" gesture="media" allow="encrypted-media" allowfullscreen=""></iframe>			</div>-->
<!--			<button class="btn lnk mdl-close aa-mdl on" data-mdl="mdl-trailer" type="button"><i class="fa-times"></i></button>-->
<!--		</div>-->
<!--		<div class="mdl-ovr aa-mdl" data-mdl="mdl-trailer"></div>-->
<!--	</div>-->
	
	
	
<div class="mdl" id="mdl-favorites">
   <div class="mdl-cn anm-b">
   </div>
   <div class="mdl-ovr aa-mdl" data-mdl="mdl-favorites"></div>
   
   