<?php
session_start();
require_once '../config.php';
?>
<!doctype html>
<html lang="en-US" prefix="og: https://ogp.me/ns#">
   <head>
      <!--meta.php-->
      <?php
         require_once ROOT_PATH . '/components/meta.php'
         ?>

<style>
    .wpcf7-response-output {
  margin: 2em 0.5em 1em;
  padding: 0.2em 1em;
  border: 2px solid #00a0d2; /* default blue */
}

.wpcf7-response-output.success {
  border-color: green;
  color: green;
}

.wpcf7-response-output.error {
  border-color: red;
  color: red;
}

</style>



   </head>
   <body class="wp-singular movies-template-default single single-movies postid-5879 wp-custom-logo wp-theme-torofilm side-right login-off ">
      <div id="aa-wp" class="cont">
      <?php
         require_once ROOT_PATH . '/components/header.php'
         ?>
<header class="section-header">
				<h1 class="section-title">Contact Us</h1>			</header>      
<div class="entry-content">
  <div class="wpcf7 js" id="wpcf7-f3490-p5320-o1" lang="en-US" dir="ltr">
    <form id="contact-form" method="post" class="wpcf7-form" novalidate>
      <p>
        <label>Your name<br>
          <input size="40" maxlength="400" name="name" required type="text" class="wpcf7-form-control">
        </label>
      </p>
      <p>
        <label>Your email<br>
          <input size="40" maxlength="400" name="email" required type="email" class="wpcf7-form-control">
        </label>
      </p>
      <p>
        <label>Subject<br>
          <input size="40" maxlength="400" name="subject" required type="text" class="wpcf7-form-control">
        </label>
      </p>
      <p>
        <label>Your message (optional)<br>
          <textarea cols="40" rows="10" maxlength="2000" name="message" class="wpcf7-form-control"></textarea>
        </label>
      </p>
      <p>
        <button type="submit" class="wpcf7-submit">Submit</button>
        <span class="wpcf7-spinner" style="display:none;">⏳</span>
      </p>
      <div id="response-msg" class="wpcf7-response-output" style="display: none;"></div>
    </form>
  </div>
</div>



<script>
document.getElementById('contact-form').addEventListener('submit', function (e) {
  e.preventDefault();

  const form = this;
  const spinner = form.querySelector('.wpcf7-spinner');
  const responseBox = document.getElementById('response-msg');
  const name = form.querySelector('input[name="name"]');
  const email = form.querySelector('input[name="email"]');
  const subject = form.querySelector('input[name="subject"]');
  const message = form.querySelector('textarea[name="message"]');

  // Reset previous errors
  [name, email, subject].forEach(field => {
    field.classList.remove('wpcf7-not-valid');
    const tip = field.parentNode.querySelector('.wpcf7-not-valid-tip');
    if (tip) tip.remove();
  });

  let hasError = false;

  function showError(field, msg) {
    field.classList.add('wpcf7-not-valid');
    const span = document.createElement('span');
    span.className = 'wpcf7-not-valid-tip';
    span.setAttribute('aria-hidden', 'true');
    span.innerText = msg;
    field.parentNode.appendChild(span);
    hasError = true;
  }

  if (!name.value.trim()) showError(name, 'Please fill out this field.');
  if (!email.value.trim()) showError(email, 'Please fill out this field.');
  if (!subject.value.trim()) showError(subject, 'Please fill out this field.');

  if (hasError) {
    responseBox.style.display = 'block';
    responseBox.textContent = 'One or more fields have an error. Please check and try again.';
    responseBox.className = 'wpcf7-response-output error';
    spinner.style.display = 'none';
    return;
  }

  // All valid, proceed with AJAX
  spinner.style.display = 'inline-block';
  responseBox.style.display = 'none';
  responseBox.textContent = '';
  responseBox.className = 'wpcf7-response-output';

  const formData = new FormData(form);

  fetch('/admin/submit_contact.php', {
    method: 'POST',
    body: formData
  })
  .then(res => res.text())
  .then(response => {
    spinner.style.display = 'none';
    responseBox.style.display = 'block';
    responseBox.textContent = response;

    if (response.includes('✅')) {
      form.reset();
      responseBox.className = 'wpcf7-response-output success';
    } else {
      responseBox.className = 'wpcf7-response-output error';
    }
  })
  .catch(() => {
    spinner.style.display = 'none';
    responseBox.style.display = 'block';
    responseBox.textContent = 'Something went wrong. Please try again.';
    responseBox.className = 'wpcf7-response-output error';
  });
});
</script>


 <?php
            require_once ROOT_PATH . '/components/footer.php'
            
            ?>
      
      </div>






   </body>
</html>
