<?php
require_once __DIR__ . '/../config.php';

// ✅ Ensure BASE_API_URL exists
if (!defined('BASE_API_URL')) {
    define('BASE_API_URL', rtrim(API_URL, '/'));
}

// Pagination setup
$page  = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$limit = 24;

// Get category slug from URL query (?id=anime)
$category  = $_GET['id'] ?? '';
$cleanCategory = preg_replace('/[^a-z0-9\-]+/i', '-', strtolower(trim($category)));

// Allowed categories
$allowed_defaults = [
    'popular', 'series', 'movie', 'top-airing',
    'complete', 'ongoing', 'latest', 'cartoon', 'anime'
];

// Base API
$api = BASE_API_URL;

// ✅ Determine correct API endpoint based on category
switch ($cleanCategory) {
    case 'series':
        $apiUrl = "$api/type/?series&page={$page}&limit={$limit}";
        break;
    case 'movie':
        $apiUrl = "$api/type/?movie&page={$page}&limit={$limit}";
        break;
    case 'top-airing':
        $apiUrl = "$api/top-airing/?page={$page}&limit={$limit}";
        break;
    case 'complete':
        $apiUrl = "$api/complete/?page={$page}&limit={$limit}";
        break;
    case 'ongoing':
        $apiUrl = "$api/ongoing/?page={$page}&limit={$limit}";
        break;
    case 'latest':
        $apiUrl = "$api/latest/?page={$page}&limit={$limit}";
        break;
    case 'cartoon':
        $apiUrl = "$api/cartoon/?page={$page}&limit={$limit}";
        break;
    case 'anime':
        $apiUrl = "$api/anime/?page={$page}&limit={$limit}";
        break;
    case 'popular':
    default:
        $apiUrl = "$api/popular/?page={$page}&limit={$limit}";
        break;
}

// Initialize defaults
$errorMessage  = '';
$searchResults = [];
$currentPage   = $page;
$totalPages    = 1;
$totalCount    = 0;

// Fetch API Data
try {
    $response = @file_get_contents($apiUrl);
    if ($response !== false) {
        $data = json_decode($response, true);
        if (!empty($data['status']) && $data['status'] === 'success' && !empty($data['data'])) {
            $searchResults = $data['data'];
            $currentPage   = $data['current_page'] ?? $page;
            $totalPages    = $data['total_pages'] ?? 1;
            $totalCount    = $data['count'] ?? 0;
        } else {
            $errorMessage = 'No results found in this category.';
        }
    } else {
        $errorMessage = 'Unable to connect to the API.';
    }
} catch (Exception $e) {
    $errorMessage = 'Error: ' . $e->getMessage();
}

// Image constants
if (!defined("TMDB_POSTER_BASE")) define("TMDB_POSTER_BASE", "https://image.tmdb.org/t/p/w500");
if (!defined("TMDB_BACKDROP_BASE")) define("TMDB_BACKDROP_BASE", "https://image.tmdb.org/t/p/w1280");

// Optional random sections
$randomSeriesApi = BASE_API_URL . "/random?limit=6&type=series";
$randomMoviesApi = BASE_API_URL . "/random?limit=6&type=movie";

function fetchRandom($url) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);
    return $data['data'] ?? [];
}

$randomSeriesList = fetchRandom($randomSeriesApi);
$randomMovieList  = fetchRandom($randomMoviesApi);
?>
<!doctype html>
<html lang="en-US" prefix="og: https://ogp.me/ns#">
   <head>
       <title><?= $cleanCategory ?> - Toonstream</title>

<meta name="twitter:title" content="<?= $cleanCategory ?> - Toonstream" />
<meta property="og:title" content="<?= $cleanCategory ?> - Toonstream" />
<meta name="twitter:label1" content="Series" />
    
      <?php require_once ROOT_PATH . '/components/meta.php'; ?>
   </head>
   <body class="archive post-type-archive post-type-archive-movies wp-custom-logo wp-theme-torofilm side-right login-off">
      <div id="aa-wp" class="cont">
         <?php require_once ROOT_PATH . '/components/header.php'; ?>

         <div class="bd">
            <div class="dfxc">
               <main class="main-site">
                  <section class="section movies">
                     <header class="section-header">
                        <div class="rw alg-cr jst-sb">
                           <?php
                           // Section Title
                           $sectionTitle = 'All Shows';
                           if (!empty($cleanCategory)) {
                               $sectionTitle = 'Category: ' . ucwords(str_replace(['-', '_'], ' ', $cleanCategory));
                           }
                           ?>
                           <h1 class="section-title">
                               <?= htmlspecialchars($sectionTitle) ?>
                               <?php if ($totalCount > 0): ?>
                                   <small>(<?= $totalCount ?> Results)</small>
                               <?php endif; ?>
                           </h1>
                        </div>
                     </header>

                     <!-- Content -->
                     <div class="aa-cn" id="aa-movies">
                        <div id="movies-a" class="aa-tb hdd on">
                           <ul class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl6e">

                           <?php if (!empty($searchResults)): ?>
                               <?php foreach ($searchResults as $item): ?>
                                   <?php
                                       $tmdb   = $item['tmdb'] ?? [];
                                       $title  = htmlspecialchars($tmdb['title'] ?? 'Unknown');
                                       $poster = !empty($tmdb['poster'])
                                           ? TMDB_POSTER_BASE . $tmdb['poster']
                                           : '/assets/no-image.jpg';
                                       $rating = isset($tmdb['rating'])
                                           ? round($tmdb['rating'], 1)
                                           : 'N/A';
                                       $type   = strtolower($tmdb['type'] ?? 'unknown');

                                       // ✅ Normalize type for clean URLs
                                       $typeSlug = ($type === 'movie') ? 'movies' : $type;
                                       $itemSlug = htmlspecialchars($tmdb['url'] ?? '#');
                                       $url = '/' . $typeSlug . '/' . $itemSlug;
                                   ?>
                                   <li class="post <?= htmlspecialchars($typeSlug) ?>">
                                      <article class="post dfx fcl <?= htmlspecialchars($typeSlug) ?>">
                                         <header class="entry-header">
                                            <h2 class="entry-title"><?= $title ?></h2>
                                            <div class="entry-meta">
                                               <span class="vote"><span>TMDB</span> <?= $rating ?></span>
                                            </div>
                                         </header>
                                         <div class="post-thumbnail or-1">
                                            <figure>
                                               <img loading="lazy" src="<?= $poster ?>" alt="Image <?= $title ?>">
                                            </figure>
                                            <span class="watch btn sm">View <?= ucfirst($typeSlug) ?></span>
                                            <span class="play fa-play"></span>
                                         </div>
                                         <a href="<?= $url ?>" class="lnk-blk"></a>
                                      </article>
                                   </li>
                               <?php endforeach; ?>
                           <?php else: ?>
                               <p style="text-align:center;">No results found.</p>
                           <?php endif; ?>
                           </ul>
                        </div>
                     </div>

lo

                    <?php if ($totalPages > 1): ?>
                        <?php
                        // ✅ Build clean pagination URLs that match htaccess
                        $pageUrl = function($p) use ($cleanCategory) {
                            return "/category/" . urlencode($cleanCategory) . "/page/" . (int)$p;
                        };
                    
                        // Pagination window setup
                        $maxLinks = 3;
                        $radius   = intdiv($maxLinks - 1, 2);
                    
                        // Determine window range
                        $start = max(1, $currentPage - $radius);
                        $end   = min($totalPages, $start + $maxLinks - 1);
                        $start = max(1, min($start, $totalPages - $maxLinks + 1));
                        ?>
                        
                        <nav class="navigation pagination">
                            <div class="nav-links">
                    
                                <!-- Prev -->
                                <?php if ($currentPage > 1): ?>
                                    <a href="<?= $pageUrl($currentPage - 1) ?>">PREV</a>
                                <?php endif; ?>
                    
                                <!-- First + ellipsis -->
                                <?php if ($start > 1): ?>
                                    <a class="page-link" href="<?= $pageUrl(1) ?>">1</a>
                                    <?php if ($start > 2): ?><a class="extend" href="javascript:void(0)">...</a><?php endif; ?>
                                <?php endif; ?>
                    
                                <!-- Number window -->
                                <?php for ($i = $start; $i <= $end; $i++): ?>
                                    <a class="page-link <?= $i === $currentPage ? 'current' : '' ?>" href="<?= $pageUrl($i) ?>"><?= $i ?></a>
                                <?php endfor; ?>
                    
                                <!-- Last + ellipsis -->
                                <?php if ($end < $totalPages): ?>
                                    <?php if ($end < $totalPages - 1): ?><a class="extend" href="javascript:void(0)">...</a><?php endif; ?>
                                    <a class="page-link" href="<?= $pageUrl($totalPages) ?>"><?= $totalPages ?></a>
                                <?php endif; ?>
                    
                                <!-- Next -->
                                <?php if ($currentPage < $totalPages): ?>
                                    <a href="<?= $pageUrl($currentPage + 1) ?>">NEXT</a>
                                <?php endif; ?>
                    
                            </div>
                        </nav>
                    <?php endif; ?>


                  </section>
               </main>
               <aside class="sidebar">
                  <div>
                     <?php require_once ROOT_PATH . '/components/sidebar.php'; ?>
                  </div>
               </aside>
            </div>
         </div>
         <?php require_once ROOT_PATH . '/components/footer.php'; ?>
         <div class="bgft"><img loading="lazy" src="/public/img/poster.jpg" alt=""></div>
      </div>
   </body>
</html>
