<section id="block-70" class="wdgt-home widget section widget_block"><div id="watch-history-widget" style="display: none;">  <section class="wdgt-home widget section watch_history_widget">
    <header class="section-header">
      <div class="rw alg-cr jst-sb">
        <h3 class="section-title">Watch History</h3>
        <button id="clear-watch-history" title="Clear Watch History" style="cursor:pointer; background: none; border: none; font-size: 16px;">🗑️</button>
      </div>
    </header>

    <div class="swiper-container watch-history-swiper-container">
      <div class="swiper-wrapper" id="watch-history-list"></div>
      <div class="swiper-pagination"></div>
    </div>
  </section>
</div>

<!-- Swiper CDN -->
<script src="https://cdn.jsdelivr.net/npm/swiper/swiper-bundle.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
  if (window.location.pathname.includes('/series/')) return;
  const widget = document.getElementById('watch-history-widget');
  const list = document.getElementById('watch-history-list');
  const data = JSON.parse(localStorage.getItem('watch_history') || '[]');

  if (!data.length) return;
  
  widget.style.display = 'block';

  // Show newest item on the left
  data.forEach(item => {
    const slide = document.createElement('div');
    slide.className = 'swiper-slide watch-history-swiper-slide';

    const extraInfo = `
      ${item.season ? `<span class="post-ql" style="background-color: rgba(0,0,0,0.7); font-size: .65rem; padding: 0 .5rem; border-radius:.2rem;">Season ${item.season}</span>` : ''}
      ${item.episode ? `<span class="year">EP: ${item.episode}</span>` : ''}
    `;

    slide.innerHTML = `
      <li>
        <article class="post dfx fcl movies">
          <div class="post-thumbnail">
            <figure><img decoding="async" src="${item.image}" alt="${item.title}"></figure>
            ${extraInfo}
            <span class="play fa-play"></span>
          </div>
          <header class="entry-header">
            <h2 class="entry-title" style="display: -webkit-box;-webkit-box-orient: vertical;-webkit-line-clamp: 1;overflow: hidden;white-space: nowrap;">${item.title}</h2>
          </header>
          <a href="${item.url}" class="lnk-blk"></a>
        </article>
      </li>
    `;
    list.appendChild(slide);
  });

  const swiper = new Swiper('.watch-history-swiper-container', {
  spaceBetween: 7,
  loop: false,
  freeMode: true,
  autoplay: false,
  breakpoints: {
    0: {
      slidesPerView: 3
    },
    576: {
      slidesPerView: 3
    },
    768: {
      slidesPerView: 4
    },
    1200: {
      slidesPerView: 5
    },
    1600: {
      slidesPerView: 6
    }
  }
});


  swiper.slideTo(0, 0); // move to the first slide

  document.getElementById('clear-watch-history').addEventListener('click', () => {
    localStorage.removeItem('watch_history');
    list.innerHTML = '';
    widget.style.display = 'none';
  });
});
</script>






<style>
.watch-history-swiper-slide > li {
  list-style: none;
  margin: 0;
  padding: 0;
}
.watch-history-swiper-container {
  overflow: hidden;
}
.post-thumbnail img {
  width: 100%;
  height: auto;
  border-radius: 6px;
}
.play.fa-play {
  position: absolute;
  bottom: 10px;
  right: 10px;
  color: white;
  background: rgba(0, 0, 0, 0.5);
  border-radius: 50%;
  padding: 8px;
  font-size: 14px;
}
.entry-title {
  font-size: 14px;
  color: white;
  margin-top: 5px;
  text-align: center;
}
.post-ql, .year {
  font-size: 12px;
  display: inline-block;
  margin-right: 5px;
  color: white;
}
</style></section>