<section class="section episodes">
  <header class="section-header">
    <div class="rw alg-cr jst-sb">
      <h3 class="section-title">Related movies</h3>
    </div>
  </header>

  <div class="owl-carousel owl-theme">
    <?php if (!empty($randomMovieList)): ?>
      <?php foreach ($randomMovieList as $item): 
        $tmdb = $item['tmdb'] ?? [];
        if (empty($tmdb)) continue;

        $title  = htmlspecialchars($tmdb['title'] ?? 'Unknown');
        $rating = htmlspecialchars(round($tmdb['rating'] ?? 0, 1));
        $poster = !empty($tmdb['poster']) ? 'https://image.tmdb.org/t/p/w185' . $tmdb['poster'] : '/assets/no-image.jpg';
        $url    = '/movies/' . htmlspecialchars($tmdb['url'] ?? '#');
        $type   = ucfirst($tmdb['type'] ?? 'Series');
      ?>
        <article class="post dfx fcl movies">
          <header class="entry-header">
            <h2 class="entry-title"><?= $title ?></h2>
            <div class="entry-meta"><span class="vote"><span>TMDB</span> <?= $rating ?></span></div>
          </header>
          <div class="post-thumbnail or-1">
            <figure>
              <img loading="lazy" src="<?= $poster ?>" alt="Image <?= $title ?>">
            </figure>
            <span class="post-ql"></span>
            <span class="watch btn sm">View <?= $type ?></span>
            <span class="play fa-play"></span>
          </div>
          <a href="<?= $url ?>" class="lnk-blk"></a>
        </article>
      <?php endforeach; ?>
    <?php else: ?>
      <p>No related series found.</p>
    <?php endif; ?>
  </div>
</section>



<script>

$(document).ready(function () {
  const owl = $('.owl-carousel');

  function adjustNavClass() {
    const nav = $('.owl-nav');
    const dots = $('.owl-dots');

    if (window.innerWidth < 1200) {
      nav.addClass('mobile-nav').removeClass('desktop-nav');
      dots.removeClass('disabled'); // Enable dots on mobile
    } else {
      nav.addClass('desktop-nav').removeClass('mobile-nav');
      dots.addClass('disabled'); // Disable dots on desktop
    }
  }

  owl.owlCarousel({
    loop: false,
    margin: 8,
    nav: true,
    dots: true,
    responsive: {
      0: { items: 2 },
      576: { items: 3 },
      768: { items: 4 },
      1200: { items: 6 },
      1600: { items: 8 }
    },
    onInitialized: adjustNavClass,     // Run after init
    onChanged: adjustNavClass          // Run after slide
  });

  $(window).on('resize', adjustNavClass);
});


</script>

