<section class="section player dfxc jst-sb episode">
   <aside class="video-player aa-cn" id="aa-options">
      <?php foreach ($sources as $index => $src): ?>
      <div id="options-<?= $index ?>" class="video aa-tb hdd <?= $index === 0 ? 'on' : '' ?>">
         <iframe <?= $index === 0 ? 'src="' . htmlspecialchars($src['url']) . '"' : 'data-src="' . htmlspecialchars($src['url']) . '"' ?> 
            frameborder="0" scrolling="no" allow="autoplay; encrypted-media" allowfullscreen></iframe>
      </div>
      <?php endforeach; ?>
   </aside>

   <aside class="video-options">
      <div class="title hdd shwc">Language</div>
      <div class="d-flex-ch">

         <?php $hasDownloads = !empty($downloads); ?>

         <!-- Trigger Button -->
         <div class="d-flex-ch mb-10 btr">
           <?php if ($hasDownloads): ?>
             <span tab="ln0" class="btn active rtg" id="open-download">Download</span>
           <?php else: ?>
             <span tab="ln0" class="btn active rtg">Multi Audio</span>
           <?php endif; ?>
         </div>

         <div id="ln0" class="lrt active">
            <ul class="aa-tbs aa-tbs-video" data-tbs="aa-options">
               <?php foreach ($sources as $index => $src): ?>
               <li>
                  <a class="btn <?= $index === 0 ? 'on' : '' ?>" href="#options-<?= $index ?>">
                     Server <span><?= $index + 1 ?></span>
                     <span class="server"><?= htmlspecialchars($src['label']) ?> - Multi Audio</span>
                  </a>
               </li>
               <?php endforeach; ?>
            </ul>
         </div>
      </div>
   </aside>
</section>

<div class="d-flex-ch j-center">
   IF Video is Not Playing Then Use Other Server Or USE 1.1.1.1 Or Proton VPN TO PLAY THE VIDEO SMOOTH
</div>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const serverButtons = document.querySelectorAll(".aa-tbs-video .btn");
    const videoOptions = document.querySelectorAll(".video-player .video");

    // Load last selected server (if any)
    const savedServer = localStorage.getItem("selectedServerIndex");
    if (savedServer && videoOptions[savedServer]) {
        serverButtons.forEach(b => b.classList.remove("on"));
        videoOptions.forEach(v => v.classList.remove("on"));

        const activeButton = serverButtons[savedServer];
        const activeVideo = videoOptions[savedServer];

        activeButton.classList.add("on");
        activeVideo.classList.add("on");

        const iframe = activeVideo.querySelector("iframe");
        if (iframe && !iframe.src && iframe.dataset.src) {
            iframe.src = iframe.dataset.src;
        }
    }

    // Handle click change
    serverButtons.forEach((btn, index) => {
        btn.addEventListener("click", function (e) {
            e.preventDefault();
            serverButtons.forEach(b => b.classList.remove("on"));
            this.classList.add("on");
            videoOptions.forEach(v => v.classList.remove("on"));
            const targetId = this.getAttribute("href").replace("#", "");
            const targetVideo = document.getElementById(targetId);

            if (targetVideo) {
                targetVideo.classList.add("on");
                const iframe = targetVideo.querySelector("iframe");
                if (iframe && !iframe.src && iframe.dataset.src) {
                    iframe.src = iframe.dataset.src;
                }
                localStorage.setItem("selectedServerIndex", index);
            }
        });
    });
});
</script>

<!-- Download Modal -->
<div class="mdl" id="mdl-download">
  <div class="mdl-cn anm-b">
    <div class="mdl-hd">
      <div class="mdl-title">Download Links</div>
      <button class="btn lnk mdl-close aa-mdl on" id="close-download" type="button">✕</button>
    </div>

    <div class="mdl-bd">
      <div class="download-links">
        <?php if (!empty($downloads)): ?>
        <table>
          <thead>
            <tr>
              <th>Server</th>
              <th>Quality</th>
              <th>Audio</th>
              <th>Link</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($downloads as $index => $dl): ?>
            <?php
              $serverName = preg_replace('/^#?\d+/', '', $dl['server'] ?? 'Unknown');
              $quality = htmlspecialchars($dl['quality'] ?? '-');
              $lang = htmlspecialchars($dl['lang'] ?? 'N/A');
              $rawUrl = $dl['url'] ?? '';
              $encodedUrl = urlencode(base64_encode($rawUrl));
            ?>
            <tr>
              <td>
                <span class="num">#<?= str_pad($index + 1, 2, '0', STR_PAD_LEFT) ?></span>
                <?= htmlspecialchars(trim($serverName)) ?>
              </td>
              <td><?= $quality ?></td>
              <td><?= $lang ?></td>
              <td>
                <?php if (!empty($rawUrl)): ?>
                  <a href="/proxy/redirect.php?u=<?= $encodedUrl ?>"
                     class="btn sm primary-bg"
                     rel="nofollow noreferrer"
                     target="_blank">Download</a>
                <?php else: ?>
                  <span style="color:#999;">N/A</span>
                <?php endif; ?>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
        <?php else: ?>
        <p style="text-align:center;color:#aaa;">No downloads available.</p>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="mdl-ovr aa-mdl" id="overlay"></div>
</div>

<?php if ($hasDownloads): ?>
<script>
  const openBtn = document.getElementById('open-download');
  const modal = document.getElementById('mdl-download');
  const closeBtn = document.getElementById('close-download');
  const overlay = document.getElementById('overlay');

  const getScrollbarWidth = () => window.innerWidth - document.documentElement.clientWidth;

  openBtn.addEventListener('click', () => {
    document.body.style.paddingRight = getScrollbarWidth() + 'px';
    document.body.style.overflow = 'hidden';
    modal.style.display = 'block';
  });

  const closeModal = () => {
    modal.style.display = 'none';
    document.body.style.overflow = '';
    document.body.style.paddingRight = '';
  };

  closeBtn.addEventListener('click', closeModal);
  overlay.addEventListener('click', closeModal);
  document.addEventListener('keydown', e => {
    if (e.key === 'Escape') closeModal();
  });
</script>
<?php endif; ?>
