<section id="widget_list_episodes-8" class="wdgt-home widget section widget_list_episodes">
    <header class="section-header">
        <div class="rw alg-cr jst-sb">
            <h3 class="section-title"></h3>
        </div>
    </header>

    <ul class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl6e eqcl">
        <?php if (!empty($latestAnimeWithImages)): ?>
            <?php foreach ($latestAnimeWithImages as $anime): ?>
                <?php
                    $tmdbId  = htmlspecialchars($anime['tmdb_id']);
                    $title   = htmlspecialchars($anime['title']);
                    $season  = htmlspecialchars($anime['season']);
                    $episode = htmlspecialchars($anime['episode']);
                    $image   = htmlspecialchars($anime['image'] ?? '/assets/no-image.jpg');
                    $updated = $anime['updated'] ?? null; // ✅ correct field
                    $timeAgo = timeAgoIST($updated);      // ✅ using existing global function

                    $episodeLabel = "{$season}x{$episode}";
                    $slug = $anime['org_slug'] ?? null;
                    $episodeUrl = "/episode/{$slug}-{$episodeLabel}/";
                ?>
                <li>
                    <article class="post dfx fcl episodes fa-play-circle">
                        <div class="post-thumbnail">
                            <figure>
                                <img loading="lazy" src="<?= $image ?>" alt="Image <?= $title ?>">
                            </figure>
                            <span class="play fa-play"></span>
                        </div>
                        <header class="entry-header">
                            <span class="num-epi"><?= $episodeLabel ?></span>
                            <h2 class="entry-title"><?= $title ?> <?= $episodeLabel ?></h2>
                            <div class="entry-meta">
                                <span class="time"><?= $timeAgo ?></span>
                            </div>
                        </header>
                        <a href="<?= $episodeUrl ?>" class="lnk-blk"></a>
                    </article>
                </li>
            <?php endforeach; ?>
        <?php else: ?>
            <li style="text-align:center;">No latest episodes found.</li>
        <?php endif; ?>
    </ul>
</section>
