

<section class="section episodes">
<?php
// Detect current season ID from the URL (works for /series/xyz-season-2-258579/)
$currentUrl = $_SERVER['REQUEST_URI'] ?? '';
$currentSeason = $seasonList[0] ?? null;

foreach ($seasonList as $s) {
    if (!empty($s['id']) && strpos($currentUrl, $s['id']) !== false) {
        $currentSeason = $s;
        break;
    }
}
?>

<header class="section-header">
    <div class="aa-drp choose-season">
        <button class="btn lnk npd aa-lnk">
            <span>choose season</span>
            <dt class="n_s" style="display:inline">
                <?= htmlspecialchars($currentSeason['title'] ?? 'Season 1') ?>
            </dt>
        </button>
        <ul class="aa-cnt sub-menu">
            <?php if (!empty($seasonList)): ?>
                <?php foreach ($seasonList as $index => $s): ?>
                    <li class="sel-temp<?= ($currentSeason['id'] ?? '') === $s['id'] ? ' active' : '' ?>">
                        <a data-post="<?= htmlspecialchars($tmdbIdValue) ?>"
                           data-season="<?= htmlspecialchars($index + 1) ?>"
                           href="/series/<?= htmlspecialchars($s['id']) ?>/">
                            <?= htmlspecialchars($s['title']) ?>
                        </a>
                    </li>
                <?php endforeach; ?>
            <?php else: ?>
                <li class="sel-temp">
                    <a data-post="<?= htmlspecialchars($tmdbIdValue) ?>" data-season="1" href="javascript:void(0)">Season 1</a>
                </li>
            <?php endif; ?>
        </ul>
    </div>
</header>


<ul id="episode_by_temp" class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl8e eqcl">
    <?php if (!empty($episodeList)): ?>
        <?php foreach ($episodeList as $ep): ?>
            <li>
                <article class="post dfx fcl episodes fa-play-circle lg">
                    <div class="post-thumbnail">
                        <figure>
                            <img loading="lazy"
                                 src="<?= $ep['image'] ?>"
                                 alt="Episode <?= $ep['episode'] ?>">
                        </figure>
                        <span class="play fa-play"></span>
                    </div>

                    <header class="entry-header">
                        <span class="num-epi">
                            <?= htmlspecialchars($ep['season']) ?>x<?= htmlspecialchars($ep['episode']) ?>
                        </span>
                        <h2 class="entry-title">
                            <?= htmlspecialchars($tmdb['title'] ?? 'Episode') ?>
                            <?= htmlspecialchars($ep['season']) ?>x<?= htmlspecialchars($ep['episode']) ?>
                        </h2>
                        <!--<div class="entry-meta">-->
                        <!--    <span class="time">Recently Added</span>-->
                        <!--</div>-->
                        <span class="view">View</span>
                    </header>

                    <a href="/episode/<?= $id ?>-<?= $ep['season'] ?>x<?= $ep['episode'] ?>/"
                       class="lnk-blk"></a>
                </article>
            </li>
        <?php endforeach; ?>
    <?php else: ?>
        <li><p>No episodes found for this season.</p></li>
    <?php endif; ?>
</ul>

</section>
				
<script>
$(document).ready(function () {
  const dropdown = $('.aa-drp.choose-season');
  const label = dropdown.find('.n_s');

  // Toggle dropdown on button click
  dropdown.find('.aa-lnk').on('click', function (e) {
    e.stopPropagation(); // Prevent the click from reaching document
    dropdown.toggleClass('on');
  });

  // Close dropdown on click anywhere else
  $(document).on('click', function () {
    dropdown.removeClass('on');
  });

  // Update season text dynamically + close dropdown + redirect
  dropdown.find('.aa-cnt a').on('click', function (e) {
    e.preventDefault(); // stop instant navigation
    const seasonName = $(this).text().trim(); // get link text (e.g. "Season 2")
    label.text(seasonName); // update button text
    dropdown.removeClass('on'); // close dropdown
    window.location.href = $(this).attr('href'); // redirect after updating
  });
});
</script>

<style>
.choose-season dt {
    margin-left: 0 !important;
}
</style>

