
<section class="section episodes">
<?php
$currentUrl = $_SERVER['REQUEST_URI'] ?? '';
$currentSeasonData = $seasonList[$tmdb['season'] - 1] ?? $seasonList[0] ?? null;
?>
<header class="section-header">
  <div class="aa-drp choose-season">
    <button class="btn lnk npd aa-lnk">
      <span>choose season</span>
      <dt class="n_s" style="display:inline">
        <?= htmlspecialchars($currentSeasonData['title'] ?? 'Season 1') ?>
      </dt>
    </button>
    <ul class="aa-cnt sub-menu">
      <?php if (!empty($seasonList)): ?>
        <?php foreach ($seasonList as $index => $s): ?>
          <li class="sel-temp<?= ($currentSeasonData['id'] ?? '') === $s['id'] ? ' active' : '' ?>">
            <a href="javascript:void(0)"
               data-post="<?= htmlspecialchars($tmdbIdValue) ?>"
               data-slug="<?= htmlspecialchars($s['id']) ?>"
               data-season="<?= htmlspecialchars($index + 1) ?>">
               <?= htmlspecialchars($s['title']) ?>
            </a>
          </li>
        <?php endforeach; ?>
      <?php else: ?>
        <li><a href="javascript:void(0)">Season 1</a></li>
      <?php endif; ?>
    </ul>
  </div>
</header>

<ul id="episode_by_temp" class="post-lst rw sm rcl2 rcl3a rcl4b rcl3c rcl4d rcl8e eqcl">
  <?php if (!empty($episodeList)): ?>
    <?php foreach ($episodeList as $ep): ?>
      <li>
        <article class="post dfx fcl episodes fa-play-circle lg">
          <div class="post-thumbnail">
            <figure><img loading="lazy" src="<?= $ep['image'] ?>" alt="Episode <?= $ep['episode'] ?>"></figure>
            <span class="play fa-play"></span>
          </div>
          <header class="entry-header">
            <span class="num-epi"><?= $ep['season'] ?>x<?= $ep['episode'] ?></span>
            <h2 class="entry-title"><?= $title ?> <?= $ep['season'] ?>x<?= $ep['episode'] ?></h2>
            <span class="view">View</span>
          </header>
          <a href="/episode/<?= $id ?>-<?= $ep['season'] ?>x<?= $ep['episode'] ?>/" class="lnk-blk"></a>
        </article>
      </li>
    <?php endforeach; ?>
  <?php else: ?>
    <li><p>No episodes found for this season.</p></li>
  <?php endif; ?>
</ul>
</section>

<script>
$(document).ready(function () {
  const dropdown = $('.aa-drp.choose-season');
  const label = dropdown.find('.n_s');
  const episodeContainer = $('#episode_by_temp');

  dropdown.find('.aa-lnk').on('click', function (e) {
    e.stopPropagation();
    dropdown.toggleClass('on');
  });
  $(document).on('click', function () { dropdown.removeClass('on'); });

  dropdown.find('.aa-cnt a').on('click', function (e) {
    e.preventDefault();
    const $this = $(this);
    const tmdb_id = $this.data('post');
    const slug = $this.data('slug');
    const seasonName = $this.text().trim();

    label.text(seasonName);
    dropdown.removeClass('on');
    episodeContainer.html('<li><p>Loading episodes...</p></li>');

    $.ajax({
      url: `/api/episodes.php?id=${slug}`,
      method: 'GET',
      dataType: 'json',
      success: function (res) {
        if (res.data && res.data.episodes && res.data.episodes.length) {
          const episodes = res.data.episodes;
          const html = episodes.map(ep => `
            <li>
              <article class="post dfx fcl episodes fa-play-circle lg">
                <div class="post-thumbnail">
                  <figure><img loading="lazy" src="${ep.image || '/assets/no-image.jpg'}" alt="Episode ${ep.episode}"></figure>
                  <span class="play fa-play"></span>
                </div>
                <header class="entry-header">
                  <span class="num-epi">${ep.season}x${ep.episode}</span>
                  <h2 class="entry-title">${res.data.tmdb.title || 'Episode'} ${ep.season}x${ep.episode}</h2>
                  <span class="view">View</span>
                </header>
                <a href="/episode/${slug}-${ep.season}x${ep.episode}/" class="lnk-blk"></a>
              </article>
            </li>
          `).join('');
          episodeContainer.html(html);
        } else {
          episodeContainer.html('<li><p>No episodes found for this season.</p></li>');
        }
      },
      error: function (xhr) {
        console.error('AJAX Error:', xhr.responseText);
        episodeContainer.html('<li><p>Failed to load episodes. Try again.</p></li>');
      }
    });
  });
});
</script>

<style>
.choose-season dt { margin-left: 0 !important; }
</style>