 <?php
// --- Detect if current page is an episode page ---
$requestUri = $_SERVER['REQUEST_URI'] ?? '';

// Broader match — catches /episode/, /episodes/, /episode-1x03, etc.
$isEpisodePage = (stripos($requestUri, 'episode') !== false);

// --- Try to detect season/episode from URL if not passed ---
if ($isEpisodePage && (empty($seasonx) || empty($total_ep))) {
    // Example patterns: /episode/1x03 or /episode-1x03
    if (preg_match('/(\d+)[xX](\d+)/', $requestUri, $m)) {
        $seasonx = $seasonx ?? $m[1];
        $total_ep = $total_ep ?? $m[2];
    }
}

// --- Compose final title ---
$displayTitle = htmlspecialchars($title);

// Append "1x12" if we have data and we’re on episode page
if ($isEpisodePage && !empty($seasonx) && !empty($total_ep)) {
    $displayTitle .= ' ' . htmlspecialchars($seasonx) . 'x' . htmlspecialchars($total_ep);
}
?>
 
 
         <style>
             :root {
    --body: #110920;
    --text: #fff;
    --link: #eeee22;
    --link-hover: #03c1ef;
    --primary: #03c1ef;
    --secondary: #8c3596;
    --tertiary: #666;
    --dark: #000;
    --light: #fff;
    --gray: #1b0f30;
    --gray-light: #311e54;
    --gray-dark: #eee;
    
}
             
         </style>



<!-- Body -->
		<div class="bd">
					<article class="post single">
			<div class="dfxb alg-cr">
				<div class="post-thumbnail alg-ss">
					<figure><img loading="lazy" src="<?= $poster ?>" alt="Image Bye Bye, Earth"></figure>
				</div>
				<aside class="fg1">
					<header class="entry-header">


<h1 class="entry-title"><?= $displayTitle ?></h1>

						<div class="entry-meta">
															<span class="genres"></span><?= $ottList ?>
														<span class="tag fa-tag"><?= $language_link ?></span>
															<span class="duration fa-clock far"><?= $runtime ?> min.</span>
																						<span class="year fa-calendar far"><?= $releaseYear ?></span>
																													<?php
function isValidNumber($val) {
    // Treat "N/A", "NA", "n/a", and 0 or empty as invalid
    return !empty($val) && is_numeric($val) && $val > 0;
}
?>
<?php
// Detect if current URL contains "/series/"
$isSeriesPage = strpos($_SERVER['REQUEST_URI'], '/series/') !== false;
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$baseUrl  = $protocol . $_SERVER['HTTP_HOST'] . strtok($_SERVER['REQUEST_URI'], '?');

?>

<?php if (isValidNumber($season)): ?>
    <span class="seasons">
        <span><?= htmlspecialchars($season) ?></span>
        Season<?= ($isSeriesPage && $season > 1 ? 's' : '') ?>
    </span>
<?php endif; ?>

<?php if (isValidNumber($total_ep)): ?>
    <span class="episodes">
        <span><?= htmlspecialchars($total_ep) ?></span>
        Episode<?= ($isSeriesPage && $total_ep > 1 ? 's' : '') ?>
    </span>
<?php endif; ?>





													</div>
					</header>
					
					<div class="description">
						<p> <?= $overview ?> </p>
<?php if (!$isEpisodePage): ?>						
<p><span style="color: #ff0000;">Language:</span> <?= $language ?></p>
<p><span style="color: #ff0000;">Quality:</span> 1080p FHD | 720p HD | 480p</p>
<p><span style="color: #ff0000;">Running time:</span> <?= $runtime ?>min</p>
<div class='code-block code-block-1' style='margin: 8px auto; text-align: center; display: block; clear: both;'>

<h5 style="background-color: white; background-image: linear-gradient(to right, #1fa2ff 0%, #12d8fa 50%, #1fa2ff 100%); border-radius: 10px; box-shadow: rgba(23, 43, 99, 0.3) 0px 7px 28px; box-sizing: inherit; color: #423d33; font-family: var(--global-heading-font-family); font-size: 17px; line-height: 1.5; margin: 0px 0px 0.5em; min-width: 0px; overflow-wrap: break-word; padding: 10px 10px 10px 25px; text-align: center;"><span style="box-sizing: inherit; color: #fcff01; min-width: 0px;"><span style="box-sizing: inherit; min-width: 0px;">For Downloading Visit <a style="box-sizing: border-box; min-width: 0px; text-decoration-line: none;" href="#">Toonhub4u</a></span></span></h5>
</div></div>
<!-- CONTENT END 1 -->
<?php endif; ?>				
					<ul class="cast-lst dfx fwp">
	<li>
   <span>Genre</span>
   <p class="loadactor"><?= $genreList ?></p>
</li>

											</ul>
				</aside>
			</div>
			<footer class="dfxa jst-sb alg-cr">
				<div class="vote-cn">
					<span class="vote fa-star"><span class="num"><?= $rating ?></span><span>TMDB</span></span>
				</div>
				<ul class="options rw rfg1 rcl0c">
											<li><button class="btn lnk npd blk aa-mdl" data-mdl="mdl-trailer"><i class="fa-youtube fab"></i> <span>Trailer</span></button></li>
															
											<li class=""><button class="btn lnk npd blk aa-mdl" onclick="window.open ('https://www.facebook.com/sharer.php?u=<?= $baseUrl ?>', 'Facebook', 'toolbar=0, status=0, width=650, height=450');"><i class="fa-facebook-f fab"></i><span>Facebook</span></button></li>
						<li><button class="btn lnk npd blk aa-mdl" onclick="javascript:window.open('https://twitter.com/intent/tweet?original_referer=<?= $baseUrl ?>&amp;text=<?= $title ?>&amp;tw_p=tweetbutton&amp;url=<?= $baseUrl ?>', 'Twitter', 'toolbar=0, status=0, width=650, height=450');"><i class="fa-twitter fab"></i><span>Twitter</span></button></li>
									</ul>
			</footer>
		</article>
					<!-- details -->