<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/config.php';

$post_id   = intval($_POST['post_id'] ?? 0);
$slug      = trim($_POST['slug'] ?? '');
$parent_id = intval($_POST['parent_id'] ?? 0);
$author    = trim($_POST['author'] ?? '');
$email     = trim($_POST['email'] ?? '');
$content   = trim($_POST['comment'] ?? '');

if (!$author || !$content || !$slug) {
    http_response_code(400);
    echo "Missing required fields";
    exit;
}

// 🟡 Try to find post by id + slug
$stmt = $pdo->prepare("SELECT id FROM posts WHERE id = ? AND slug = ? LIMIT 1");
$stmt->execute([$post_id, $slug]);
$post = $stmt->fetch();

if (!$post) {
    // 🔁 Try by slug only
    $stmt = $pdo->prepare("SELECT id FROM posts WHERE slug = ? LIMIT 1");
    $stmt->execute([$slug]);
    $post = $stmt->fetch();

    if ($post) {
        $post_id = $post['id'];
    } else {
        // ✅ Try-Catch block for insert (in case slug already exists)
        try {
            $stmt = $pdo->prepare("INSERT INTO posts (title, slug) VALUES (?, ?)");
            $stmt->execute(['Auto Created: ' . $slug, $slug]);
            $post_id = $pdo->lastInsertId();
        } catch (PDOException $e) {
            // 🔁 If already exists due to race condition
            $stmt = $pdo->prepare("SELECT id FROM posts WHERE slug = ? LIMIT 1");
            $stmt->execute([$slug]);
            $post = $stmt->fetch();

            if (!$post) {
                http_response_code(400);
                echo "Could not create post.";
                exit;
            }

            $post_id = $post['id'];
        }
    }
}


// ✅ Insert the comment
$stmt = $pdo->prepare("INSERT INTO comments (post_id, parent_id, author, email, content, slug, approved) VALUES (?, ?, ?, ?, ?, ?, 0)");
$stmt->execute([$post_id, $parent_id, $author, $email, $content, $slug]);

// 🍪 Set cookie so user can see their unapproved comment
setcookie('comment_email', $email, time() + (86400 * 365), "/"); // 1 year

echo "success";
