<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/config.php';

$post_id = intval($_GET['post_id'] ?? 0);
$email_cookie = $_COOKIE['comment_email'] ?? '';

if (!$post_id) {
    http_response_code(400);
    echo "Post ID missing.";
    exit;
}

function render_comments($comments, $parent_id = 0, $all_comments = [], $email_cookie = '') {
    $html = $parent_id ? '<ol class="children">' : '<ul class="comment-list">';

    foreach ($comments as $comment) {
        if (intval($comment['parent_id']) === $parent_id) {
            $cid = intval($comment['id']);
            $author = htmlspecialchars($comment['author']);
            $content = nl2br(htmlspecialchars($comment['content']));
            $created_at = date('F j, Y \a\t g:i a', strtotime($comment['created_at']));
            $email = trim($comment['email']);
            $gravatar = 'https://www.gravatar.com/avatar/' . md5(strtolower($email)) . '?s=50&d=mm';

            // Show only approved comments or unapproved if email matches
            if (!$comment['approved'] && strtolower($email) !== strtolower($email_cookie)) {
                continue;
            }

            // Mention parent
            if ($comment['parent_id'] != 0) {
                foreach ($all_comments as $c) {
                    if ($c['id'] == $comment['parent_id']) {
                        $mention = '<span class="mention">@' . htmlspecialchars($c['author']) . '</span> ';
                        $content = $mention . $content;
                        break;
                    }
                }
            }

            $html .= "<li id='comment-$cid' class='comment'>";
            $html .= "<article id='div-comment-$cid' class='comment-body'>";
            $html .= "<footer class='comment-meta'>";
            $html .= "<div class='comment-author vcard'>";
            $html .= "<img alt='' src='$gravatar' class='avatar avatar-50 photo' height='50' width='50'> ";
            $html .= "<b class='fn'>$author</b> <span class='says'>says:</span>";
            $html .= "</div>";
            $html .= "<div class='comment-metadata'>";
            $html .= "<a href='#comment-$cid'><time datetime='" . htmlspecialchars($comment['created_at']) . "'>$created_at</time></a>";
            $html .= "</div>";

            if (!$comment['approved']) {
                $html .= "<em class='comment-awaiting-moderation'>Your comment is awaiting moderation. This is a preview; your comment will be visible after it has been approved.</em>";
            }

            $html .= "</footer>";
            $html .= "<div class='comment-content'><p>$content</p></div>";
            $html .= "<div class='reply'>";
            $html .= "<a rel='nofollow' class='comment-reply-link' href='javascript:void(0)' data-commentid='$cid' data-replyto='Reply to $author'>Reply</a>";
            $html .= "</div>";
            $html .= "<div class='form-slot' data-commentid='$cid'></div>";

            $html .= render_comments($comments, $cid, $all_comments, $email_cookie);
            $html .= "</article></li>";
        }
    }

    $html .= $parent_id ? '</ol>' : '</ul>';
    return $html;
}

$stmt = $pdo->prepare("SELECT * FROM comments WHERE post_id = ? ORDER BY created_at ASC");
$stmt->execute([$post_id]);
$all_comments = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Include all for nesting logic, but filter rendering in function
echo render_comments($all_comments, 0, $all_comments, $email_cookie);
