<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/config.php';

$uri = $_SERVER['REQUEST_URI'];
$path = trim(parse_url($uri, PHP_URL_PATH), '/');
$parts = explode('/', $path);
$last = array_pop($parts);
$last = preg_replace('/\.php$/', '', $last);
$parts[] = $last;
$slug = implode('/', $parts);

if (!$slug) {
    die("Invalid slug.");
}

$stmt = $pdo->prepare("SELECT id FROM posts WHERE slug = ? LIMIT 1");
$stmt->execute([$slug]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$row) {
    $stmt = $pdo->prepare("INSERT INTO posts (title, slug) VALUES (?, ?)");
    $stmt->execute(["Auto Created: $slug", $slug]);
    $post_id = $pdo->lastInsertId();
} else {
    $post_id = intval($row['id']);
}
?>


  <!-- Comments section -->
  <div id="comments" class="comments-area widget">
    <div class="comments-title widget-title">Comments</div>
    <nav class="navigation pagination comments-nav"></nav>
    <div id="comment-list"></div>
    <nav class="navigation pagination comments-nav"></nav>

   <div id="respond-container">
  <div id="respond" class="comment-respond">
    <div id="reply-title" class="comments-title comment-reply-title widget-title">
      Leave a Reply <small>
        <a rel="nofollow" id="cancel-comment-reply-link" href="javascript:void(0)" style="display:none;">Cancel reply</a>
      </small>
    </div>

      <form id="comment-form" class="comment-form">
        <p class="comment-notes">
          <span id="email-notes">Your email address will not be published.</span>
          <span class="required-field-message">
            Required fields are marked <span class="required">*</span>
          </span>
        </p>

        <!-- Hidden inputs -->
        <input type="hidden" name="post_id" id="post_id" value="<?= $post_id ?>">
        <input type="hidden" name="slug" id="slug" value="<?= htmlspecialchars($slug) ?>">
        <input type="hidden" name="parent_id" id="parent_id" value="0">
        <input type="hidden" name="mention_prefix" id="mention_prefix" value="">
        <a rel="nofollow" id="cancel-comment-reply-link" href="javascript:void(0)" style="display:none;">Cancel reply</a>


        <p class="comment-form-comment">
          <label for="comment">Comment <span class="required">*</span></label>
          <textarea id="comment" name="comment" cols="45" rows="8" maxlength="65525" required></textarea>
        </p>
        <p class="comment-form-author">
          <label for="author">Name <span class="required">*</span></label>
          <input id="author" name="author" type="text" value="" size="30" maxlength="245" autocomplete="name" required>
        </p>
        <p class="comment-form-email">
          <label for="email">Email <span class="required">*</span></label>
          <input id="email" name="email" type="email" value="" size="30" maxlength="100" autocomplete="email" required>
        </p>
        <p class="comment-form-url">
          <label for="url">Website</label>
          <input id="url" name="url" type="url" value="" size="30" maxlength="200" autocomplete="url">
        </p>
        <p class="comment-form-cookies-consent">
          <input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes">
          <label for="wp-comment-cookies-consent">Save my info for next time.</label>
        </p>
        <p class="form-submit">
          <input name="submit" type="submit" id="submit" class="submit" value="Post Comment">
        </p>
      </form>
    </div>
  </div>

  <script>
document.addEventListener('DOMContentLoaded', function () {
  const postId = document.getElementById('post_id').value;
  const slug = document.getElementById('slug').value;
  const respond = document.getElementById('respond');
  const respondContainer = document.getElementById('respond-container');
  const cancelLink = document.getElementById('cancel-comment-reply-link');
  const parentInput = document.getElementById('parent_id');
  const respondTitle = document.getElementById('reply-title');
  const mentionPrefix = document.getElementById('mention_prefix'); // ✅ moved here
  const commentField = document.getElementById('comment');         // ✅ moved here


  // Load Comments
  function loadComments() {
    fetch(`/components/comment/load_comments.php?post_id=${postId}`)
      .then(res => res.text())
      .then(html => {
        document.getElementById('comment-list').innerHTML = html;
      })
      .catch(err => console.error("Error loading comments:", err));
  }
  loadComments();

  // Submit Comment
document.getElementById('comment-form').addEventListener('submit', function (e) {
  e.preventDefault();
  const formData = new FormData(this);

  // 🔁 Prepend mention prefix to comment field (if any)
  const mention = mentionPrefix.value.trim();
  const commentText = commentField.value.trim();
  formData.set('comment', mention + commentText);

  fetch('/components/comment/submit_comment.php', {
    method: 'POST',
    body: formData
  })
  .then(res => res.text())
  .then(response => {
    if (response.trim() === "success") {
      this.reset();
      parentInput.value = 0;
      mentionPrefix.value = '';
      respondContainer.appendChild(respond);
      cancelLink.style.display = 'none';
      respondTitle.innerHTML = `Leave a Reply <small><a rel="nofollow" id="cancel-comment-reply-link" href="javascript:void(0)" style="display:none;">Cancel reply</a></small>`;
      loadComments();
    } else {
      alert("Error: " + response);
    }
  })
  .catch(err => console.error("Submit error:", err));
});


  // Delegate click for reply links
  document.addEventListener('click', function (e) {
    if (e.target.classList.contains('comment-reply-link')) {
      e.preventDefault();
      const commentId = e.target.dataset.commentid;
      const commentBox = document.getElementById(`comment-${commentId}`);
      const slot = commentBox.querySelector('.form-slot');

      parentInput.value = commentId;
      slot.innerHTML = '';
      slot.appendChild(respond);

      const authorName = commentBox.querySelector('.fn')?.textContent || '';
      respondTitle.innerHTML = `Reply to ${authorName} <small><a rel="nofollow" id="cancel-comment-reply-link" href="javascript:void(0)">Cancel reply</a></small>`;
      cancelLink.style.display = '';
    }

    if (e.target.id === 'cancel-comment-reply-link') {
      e.preventDefault();
      parentInput.value = 0;
      respondContainer.appendChild(respond);
      cancelLink.style.display = 'none';
      respondTitle.innerHTML = `Leave a Reply <small><a rel="nofollow" id="cancel-comment-reply-link" href="javascript:void(0)" style="display:none;">Cancel reply</a></small>`;
    }
  });
});

document.addEventListener('click', function (e) {
  if (e.target.classList.contains('comment-reply-link')) {
    e.preventDefault();
    const commentId = e.target.dataset.commentid;
    const commentBox = document.getElementById(`comment-${commentId}`);
    const slot = commentBox.querySelector('.form-slot');

    parentInput.value = commentId;
    slot.innerHTML = '';
    slot.appendChild(respond);

    const authorName = commentBox.querySelector('.fn')?.textContent.trim() || '';
    respondTitle.innerHTML = `Reply to ${authorName} <small><a rel="nofollow" id="cancel-comment-reply-link" href="javascript:void(0)">Cancel reply</a></small>`;
    cancelLink.style.display = '';

    // 🟢 Set mention (but do NOT show it in textarea)
    mentionPrefix.value = `@${authorName} `;
  }

  if (e.target.id === 'cancel-comment-reply-link') {
    e.preventDefault();
    parentInput.value = 0;
    mentionPrefix.value = '';
    respondContainer.appendChild(respond);
    cancelLink.style.display = 'none';
    respondTitle.innerHTML = `Leave a Reply <small><a rel="nofollow" id="cancel-comment-reply-link" href="javascript:void(0)" style="display:none;">Cancel reply</a></small>`;
  }
});

</script>

<style>

span.mention {
    color: #867fb1;
}


</style>