<?php
header('Content-Type: application/json');
require_once($_SERVER['DOCUMENT_ROOT'] . '/config.php');

$cacheDir = $_SERVER['DOCUMENT_ROOT'] . '/cache/schedule';
if (!file_exists($cacheDir)) {
    mkdir($cacheDir, 0777, true);
}

$allowedRef = $websiteUrl ?? ''; // ensure it's defined
if (
    !isset($_SERVER['HTTP_REFERER']) ||
    strpos($_SERVER['HTTP_REFERER'], $allowedRef) !== 0
) {
    http_response_code(403);
    echo json_encode(['error' => 'Mat Kro Mere Bhai']);
    exit;
}

if (
    !isset($_SERVER['HTTP_X_REQUESTED_WITH']) ||
    $_SERVER['HTTP_X_REQUESTED_WITH'] !== 'schedule-anime-world'
) {
    http_response_code(403);
    echo json_encode(['error' => 'Mat Kro Mere Bhai']);
    exit;
}

if (empty($_GET['date'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Mat Kro Mere Bhai']);
    exit;
}

$animedate = urlencode(trim($_GET['date']));
$cacheFile = "$cacheDir/schedule_$animedate.json";

// ✅ Serve from cache if fresh (6 hours)
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < 21600) {
    echo file_get_contents($cacheFile);
    exit;
}

// ✅ Use correct constant (not $API_URL)
$externalApiUrl = API_URL . "/schedule/?date={$animedate}";

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $externalApiUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 8,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_SSL_VERIFYPEER => false,
]);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// ✅ Cache successful response
if ($httpCode === 200 && $response) {
    file_put_contents($cacheFile, $response);
}

http_response_code($httpCode);
echo $response ?: json_encode(['error' => 'No response from API']);
