<?php
require_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim($_POST['name'] ?? '');
  $email = trim($_POST['email'] ?? '');
  $subject = trim($_POST['subject'] ?? '');
  $message = trim($_POST['message'] ?? '');

  // Server-side validation
  if (!$name || !$email || !$subject) {
    echo "❌ Please fill in all required fields.";
    exit;
  }

  if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo "❌ Invalid email address. Please check and try again.";
    exit;
  }

  // Optional: limit length to prevent abuse
  if (strlen($name) > 400 || strlen($email) > 400 || strlen($subject) > 400 || strlen($message) > 2000) {
    echo "❌ One or more fields exceed maximum allowed length.";
    exit;
  }

  // Insert into database
  $stmt = $pdo->prepare("INSERT INTO contact_messages (name, email, subject, message) VALUES (?, ?, ?, ?)");
  $stmt->execute([$name, $email, $subject, $message]);

  echo "✅ Message sent successfully.";
} else {
  echo "❌ Invalid request.";
}
