<?php
session_start();
require_once '../config.php';

// Admin check
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

// Check if IDs are sent via POST
if (!empty($_POST['contact_ids']) && is_array($_POST['contact_ids'])) {
    $ids = $_POST['contact_ids'];

    // Sanitize and build placeholders for query
    $placeholders = rtrim(str_repeat('?,', count($ids)), ',');

    $stmt = $pdo->prepare("DELETE FROM contact_messages WHERE id IN ($placeholders)");
    if ($stmt->execute($ids)) {
        $_SESSION['success'] = "Selected messages deleted successfully.";
    } else {
        $_SESSION['error'] = "Failed to delete selected messages.";
    }
}

header("Location: dashboard.php"); // or wherever your dashboard is
exit;
