<?php
session_start();
require_once '../config.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}


// Fetch comments
$commentStmt = $pdo->query("SELECT * FROM comments ORDER BY created_at DESC");
$comments = $commentStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch contact messages
$contactStmt = $pdo->query("SELECT * FROM contact_messages ORDER BY created_at DESC");
$contact_messages = $contactStmt->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html>
<head>
  <title>Admin Dashboard</title>
  <link rel="stylesheet" href="admin.css">
  <style>


    .tabs {
      display: flex;
      gap: 10px;
      margin-bottom: 20px;
    }

    .tab {
      padding: 10px 20px;
      background: #000;
      cursor: pointer;
      border-radius: 5px;
    }

    .tab.active {
      background: #007bff;
      color: white;
    }

    .comment-box {
      padding: 15px;
      border-bottom: 1px solid #ddd;
      margin-bottom: 10px;
     
      border-left: 5px solid #ccc;
    }

    .comment-box.approved {
      border-left-color: #4CAF50;
    }

    .comment-box.pending {
      border-left-color: #f39c12;
    }

    .btn {
      padding: 5px 10px;
      text-decoration: none;
      margin-right: 5px;
      display: inline-block;
    }

    .btn.approve {
      background: #4CAF50;
      color: white;
    }

    .btn.delete {
      background: #e74c3c;
      color: white;
    }

    .logout {
      float: right;
      text-decoration: none;
      background: #333;
      color: white;
      padding: 5px 10px;
      border-radius: 5px;
    }

    .comment-section {
      display: none;
    }

    .comment-section.active {
      display: block;
    }
.comment-box {
  display: flex;
  justify-content: space-between;
  align-items: flex-start;
  padding: 15px;
  border-bottom: 1px solid #ddd;
  margin-bottom: 10px;
  border-left: 5px solid #ccc;
}

.comment-box.approved {
  border-left-color: #4CAF50;
}

.comment-box.pending {
  border-left-color: #f39c12;
}

.comment-box-content {
  flex: 1;
  padding-right: 15px;
}

.comment-box-checkbox {
  display: flex;
  align-items: flex-start;
  padding-top: 5px;
}

.comment-box-checkbox input[type="checkbox"] {
  transform: scale(1.3);
  cursor: pointer;
}
.schedule-entry {
  margin-bottom: 10px;
}
.schedule-entry input {
  margin-right: 10px;
}
.add-entry-btn {
  margin: 5px 0 20px;
  background: #007bff;
  color: #fff;
  border: none;
  padding: 6px 12px;
  cursor: pointer;
  border-radius: 4px;
}

  </style>
</head>
<body>
  <div class="dashboard">
    <a href="logout.php" class="logout">Logout</a>
    <h2 id="dashboard-title">Comments Moderation</h2>

    <div class="tabs">
      <div class="tab active" data-tab="all">All</div>
      <div class="tab" data-tab="approved">Approved</div>
      <div class="tab" data-tab="pending">Pending</div>
      <div class="tab" data-tab="schedule">Schedule</div>
      <div class="tab" data-tab="contact-us">Contact Us</div>
    </div>

<!-- All Comments -->
<div id="comments-all" class="comment-section active">
  <form method="post" action="./bulk_delete.php">
    <label><input type="checkbox" class="select-all" data-section="all"> Select All</label><button type="submit" class="btn delete" onclick="return confirm('Delete selected comments?')">Delete Selected</button>

    <?php foreach ($comments as $c): ?>
      <div class="comment-box <?= $c['approved'] ? 'approved' : 'pending' ?>">
        <div class="comment-box-content">
          <p><strong><?= htmlspecialchars($c['author']) ?></strong> (<?= $c['email'] ?>)</p>
          <p><?= nl2br(htmlspecialchars($c['content'])) ?></p>
          <small>
            <?= $c['created_at'] ?> |
            <a style="color:#22ff4a;" href="<?= SITE_URL ?>/<?= $c['slug'] ?>" target="_blank"><?= htmlspecialchars($c['slug']) ?></a>
          </small><br>
          <?php if (!$c['approved']): ?>
            <a href="approve_comment.php?id=<?= $c['id'] ?>" class="btn approve">Approve</a>
          <?php endif; ?>
          <a href="delete_comment.php?id=<?= $c['id'] ?>" class="btn delete" onclick="return confirm('Delete this comment?')">Delete</a>
        </div>
        <div class="comment-box-checkbox">
          <input type="checkbox" name="comment_ids[]" value="<?= $c['id'] ?>" class="checkbox-all">
        </div>
      </div>
    <?php endforeach; ?>
  </form>
</div>

<!-- Approved Comments -->
<div id="comments-approved" class="comment-section">
  <form method="post" action="bulk_delete.php">
    <label><input type="checkbox" class="select-all" data-section="approved"> Select All</label>
    <button type="submit" class="btn delete" onclick="return confirm('Delete selected comments?')">Delete Selected</button>

    <?php foreach ($comments as $c): if ($c['approved']): ?>
      <div class="comment-box approved">
        <div class="comment-box-content">
          <p><strong><?= htmlspecialchars($c['author']) ?></strong> (<?= $c['email'] ?>)</p>
          <p><?= nl2br(htmlspecialchars($c['content'])) ?></p>
          <small>
            <?= $c['created_at'] ?> |
            <a style="color:#22ff4a;" href="<?= SITE_URL ?>/<?= $c['slug'] ?>" target="_blank"><?= htmlspecialchars($c['slug']) ?></a>
          </small><br>
          <a href="delete_comment.php?id=<?= $c['id'] ?>" class="btn delete" onclick="return confirm('Delete this comment?')">Delete</a>
        </div>
        <div class="comment-box-checkbox">
          <input type="checkbox" name="comment_ids[]" value="<?= $c['id'] ?>" class="checkbox-approved">
        </div>
      </div>
    <?php endif; endforeach; ?>
  </form>
</div>

<!-- Pending Comments -->
<div id="comments-pending" class="comment-section">
  <form method="post" action="bulk_delete.php">
    <label><input type="checkbox" class="select-all" data-section="pending"> Select All</label>
    <button type="submit" class="btn delete" onclick="return confirm('Delete selected comments?')">Delete Selected</button>

    <?php foreach ($comments as $c): if (!$c['approved']): ?>
      <div class="comment-box pending">
        <div class="comment-box-content">
          <p><strong><?= htmlspecialchars($c['author']) ?></strong> (<?= $c['email'] ?>)</p>
          <p><?= nl2br(htmlspecialchars($c['content'])) ?></p>
          <small>
            <?= $c['created_at'] ?> |
            <a style="color:#22ff4a;" href="<?= SITE_URL ?>/<?= $c['slug'] ?>" target="_blank"><?= htmlspecialchars($c['slug']) ?></a>
          </small><br>
          <a href="approve_comment.php?id=<?= $c['id'] ?>" class="btn approve">Approve</a>
          <a href="delete_comment.php?id=<?= $c['id'] ?>" class="btn delete" onclick="return confirm('Delete this comment?')">Delete</a>
        </div>
        <div class="comment-box-checkbox">
          <input type="checkbox" name="comment_ids[]" value="<?= $c['id'] ?>" class="checkbox-pending">
        </div>
      </div>
    <?php endif; endforeach; ?>
  </form>
</div>


<div id="comments-schedule" class="comment-section">

  <form method="post" action="update_schedule.php">
    <?php
    $days = ['monday','tuesday','wednesday','thursday','friday','saturday','sunday'];
    foreach ($days as $day): ?>
      <h4><?= ucfirst($day) ?></h4>
      <div class="day-schedule" data-day="<?= $day ?>">
        <?php
        $stmt = $pdo->prepare("SELECT * FROM schedules WHERE day = ? ORDER BY time ASC");
        $stmt->execute([$day]);
        $entries = $stmt->fetchAll();
        foreach ($entries as $entry): ?>
          <div class="schedule-entry">
            <input type="hidden" name="existing_ids[]" value="<?= $entry['id'] ?>">
            <input type="text" name="existing_times[]" value="<?= htmlspecialchars($entry['time']) ?>" placeholder="Time">
            <input type="text" name="existing_descriptions[]" value="<?= htmlspecialchars($entry['description']) ?>" placeholder="Description">
            <button type="button" class="remove-entry-btn" style="margin-left:10px;" data-id="<?= $entry['id'] ?>">✕ Remove</button>
          </div>
        <?php endforeach; ?>
      </div>
      <div>
        <button type="button" class="add-entry-btn" data-day="<?= $day ?>">+ Add More Field</button>
      </div>
    <?php endforeach; ?>

    <!-- Hidden input for delete tracking -->
    <input type="hidden" name="delete_ids" id="delete_ids">
</br>
    <button style="background:red;" type="submit">Save Schedule</button>
  </form>
</div>



<div id="comments-contact-us" class="comment-section">
<form method="post" action="delete_contact_messages.php">
  <label><input type="checkbox" class="select-all" data-section="contact"> Select All</label>
  <button type="submit" class="btn delete" onclick="return confirm('Delete selected messages?')">Delete Selected</button>

  <?php foreach ($contact_messages as $msg): ?>
    <div class="comment-box">
      <div class="comment-box-content">
        <p><strong>Name:</strong> <?= htmlspecialchars($msg['name']) ?></p>
        <p><strong>Email:</strong> <?= htmlspecialchars($msg['email']) ?></p>
        <p><strong>Subject:</strong> <?= htmlspecialchars($msg['subject']) ?></p>
        <p><strong>Message:</strong> <?= nl2br(htmlspecialchars($msg['message'])) ?></p>
        <p><small><strong>Sent:</strong> <?= $msg['created_at'] ?></small></p>
      </div>
      <div class="comment-box-checkbox">
        <input type="checkbox" name="contact_ids[]" value="<?= $msg['id'] ?>" class="checkbox-contact">
      </div>
    </div>
  <?php endforeach; ?>
</form>
</div>



<script>
const deleteIds = [];

// + Add new entry dynamically
document.querySelectorAll('.add-entry-btn').forEach(button => {
  button.addEventListener('click', function () {
    const day = this.getAttribute('data-day');
    const container = document.querySelector(`.day-schedule[data-day="${day}"]`);

    const newDiv = document.createElement('div');
    newDiv.classList.add('schedule-entry');
    newDiv.innerHTML = `
      <input type="text" name="new_times[${day}][]" placeholder="Time">
      <input type="text" name="new_descriptions[${day}][]" placeholder="Description">
      <button type="button" class="remove-entry-btn" style="margin-left:10px;">❌</button>
    `;
    container.appendChild(newDiv);

    // Bind remove button for dynamically added field
    newDiv.querySelector('.remove-entry-btn').addEventListener('click', function () {
      if (confirm('Are you sure you want to remove this new entry?')) {
        newDiv.remove();
      }
    });
  });
});

// ❌ Remove existing entries with confirmation
document.querySelectorAll('.remove-entry-btn').forEach(btn => {
  btn.addEventListener('click', function () {
    const entry = this.closest('.schedule-entry');
    const id = this.getAttribute('data-id');

    if (id && confirm('Are you sure you want to delete this schedule entry from the database?')) {
      // 🔁 Send AJAX request
      fetch('delete_schedule_entry.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'id=' + encodeURIComponent(id)
      })
      .then(res => res.text())
      .then(response => {
        if (response === 'success') {
          entry.remove(); // ✅ Remove from DOM
        } else {
          alert('Failed to delete. Try again.');
        }
      })
      .catch(() => alert('Error deleting. Please try later.'));
    }
  });
});

</script>






<script>
  const tabs = document.querySelectorAll('.tab');
  const sections = document.querySelectorAll('.comment-section');

  tabs.forEach(tab => {
    tab.addEventListener('click', () => {
      tabs.forEach(t => t.classList.remove('active'));
      sections.forEach(s => s.classList.remove('active'));

      tab.classList.add('active');
      const targetId = 'comments-' + tab.dataset.tab;
      const targetSection = document.getElementById(targetId);
      if (targetSection) {
        targetSection.classList.add('active');
      }

      // Optional: Change main heading dynamically
      const mainHeading = document.querySelector('h2');
      if (tab.dataset.tab === 'contact-us') {
        mainHeading.textContent = 'Contact Messages';
      } else if (tab.dataset.tab === 'schedule') {
        mainHeading.textContent = 'Edit Weekly Schedule';
      } else {
        mainHeading.textContent = 'Comments Moderation';
      }
    });
  });

  // Auto-click pending tab on load
  window.addEventListener('DOMContentLoaded', () => {
    document.querySelector('.tab[data-tab="pending"]')?.click();
  });

  // Handle "Select All" checkboxes
  document.querySelectorAll('.select-all').forEach(masterCheckbox => {
    masterCheckbox.addEventListener('change', () => {
      const section = masterCheckbox.dataset.section;
      const checkboxes = document.querySelectorAll('.checkbox-' + section);
      checkboxes.forEach(cb => cb.checked = masterCheckbox.checked);
    });
  });
</script>



</body>
</html>
